/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.impl.features;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2960;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.betterx.wover.feature.api.features.config.TemplateFeatureConfig;
import org.betterx.wover.structure.api.StructureNBT;

public class FeatureTemplateImpl
extends StructureNBT
implements TemplateFeatureConfig.FeatureTemplate {
    public static final Codec<TemplateFeatureConfig.FeatureTemplate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("location").forGetter(cfg -> cfg.getLocation()), (App)Codec.INT.fieldOf("offset_y").orElse((Object)0).forGetter(cfg -> cfg.getOffsetY())).apply((Applicative)instance, FeatureTemplateImpl::new));
    public final int offsetY;
    private static final Map<String, FeatureTemplateImpl> READER_CACHE = Maps.newHashMap();

    protected FeatureTemplateImpl(class_2960 location, int offsetY) {
        super(location);
        this.offsetY = offsetY;
    }

    public static TemplateFeatureConfig.FeatureTemplate createTemplate(class_2960 location) {
        return FeatureTemplateImpl.createTemplate(location, 0);
    }

    public static TemplateFeatureConfig.FeatureTemplate createTemplate(class_2960 location, int offsetY) {
        String key = location.toString() + "::" + offsetY;
        return READER_CACHE.computeIfAbsent(key, r -> new FeatureTemplateImpl(location, offsetY));
    }

    public boolean generateIfPlaceable(class_5425 level, class_2338 pos, class_5819 random) {
        return this.generateIfPlaceable(level, pos, FeatureTemplateImpl.getRandomRotation((class_5819)random), FeatureTemplateImpl.getRandomMirror((class_5819)random));
    }

    @Override
    public boolean generateIfPlaceable(class_5425 level, class_2338 pos, class_2470 r, class_2415 m) {
        if (this.canGenerate((class_1936)level, pos, r)) {
            return this.generate(level, pos, r, m);
        }
        return false;
    }

    public boolean generate(class_5425 level, class_2338 pos, class_2470 r, class_2415 m) {
        return this.generateCentered(level, pos.method_10086(this.offsetY), r, m);
    }

    public boolean canGenerate(class_1936 level, class_2338 pos, class_2470 rotation) {
        return !this.containsBedrock(level, pos);
    }

    private boolean containsBedrock(class_1936 level, class_2338 startPos) {
        for (int i = 0; i < this.structure.method_15160().method_10264(); i += 2) {
            if (!level.method_8320(startPos.method_10086(i)).method_27852(class_2246.field_9987)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean loaded() {
        return this.structure != null;
    }

    @Override
    public int getOffsetY() {
        return this.offsetY;
    }

    @Override
    public class_2960 getLocation() {
        return this.location;
    }
}

