/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.impl.configured;

import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import org.betterx.wover.core.api.registry.DatapackRegistryBuilder;
import org.betterx.wover.events.api.types.OnBootstrapRegistry;
import org.betterx.wover.events.impl.EventImpl;
import org.betterx.wover.feature.impl.configured.RandomPatchImpl;
import org.betterx.wover.feature.impl.placed.FeaturePlacementBuilderImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FeatureConfiguratorImpl<FC extends class_3037, F extends class_3031<FC>> {
    public static final EventImpl<OnBootstrapRegistry<class_2975<?, ?>>> BOOTSTRAP_CONFIGURED_FEATURES = new EventImpl("BOOTSTRAP_CONFIGURED_FEATURES");
    private static boolean didInit = false;
    @Nullable
    public final class_5321<class_2975<?, ?>> key;
    @Nullable
    protected final class_7891<class_2975<?, ?>> bootstrapContext;
    private class_5321<class_6796> transitiveFeatureKey;
    private class_7891<class_6796> transitiveBootstrapContext;

    @ApiStatus.Internal
    public static void initialize() {
        if (didInit) {
            return;
        }
        didInit = true;
        DatapackRegistryBuilder.addBootstrap((class_5321)class_7924.field_41239, FeatureConfiguratorImpl::onBootstrap);
    }

    private static void onBootstrap(class_7891<class_2975<?, ?>> context) {
        BOOTSTRAP_CONFIGURED_FEATURES.emit(c -> c.bootstrap(context));
    }

    @NotNull
    public static class_5321<class_2975<?, ?>> createKey(@NotNull class_2960 id) {
        return class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)id);
    }

    @Nullable
    public static <FC extends class_3037, F extends class_3031<FC>> class_6880<class_2975<?, ?>> getHolder(@Nullable class_7871<class_2975<?, ?>> getter, @NotNull class_5321<class_2975<?, ?>> key) {
        if (getter == null) {
            return null;
        }
        Optional h = getter.method_46746(key);
        return h.orElse(null);
    }

    FeatureConfiguratorImpl(@Nullable class_7891<class_2975<?, ?>> ctx, @Nullable class_5321<class_2975<?, ?>> key) {
        this.key = key;
        this.bootstrapContext = ctx;
    }

    void setTransitive(class_7891<class_6796> ctx, class_5321<class_6796> key) {
        this.transitiveBootstrapContext = ctx;
        this.transitiveFeatureKey = key;
    }

    @ApiStatus.Internal
    public class_5321<class_6796> getTransitiveFeatureKey() {
        return this.transitiveFeatureKey;
    }

    @ApiStatus.Internal
    public class_7891<class_6796> getTransitiveBootstrapContext() {
        return this.transitiveBootstrapContext;
    }

    @NotNull
    protected abstract FC createConfiguration();

    @NotNull
    protected abstract F getFeature();

    public class_6880<class_2975<?, ?>> register() {
        if (this.key == null) {
            throw new IllegalStateException("A ResourceKey can not be null if a feature should be registered!");
        }
        if (this.bootstrapContext == null) {
            this.throwStateError("Can not register a feature without a bootstrap context!");
        }
        class_2975<FC, F> cFeature = this.build();
        return this.bootstrapContext.method_46838(this.key, cFeature);
    }

    public class_6880<class_2975<?, ?>> directHolder() {
        return class_6880.method_40223(this.build());
    }

    public FeaturePlacementBuilderImpl inlinePlace() {
        return FeaturePlacementBuilderImpl.withTransitive(this, (cfg, plc) -> {
            RandomPatchImpl res = new RandomPatchImpl(this.bootstrapContext, (class_5321<class_2975<?, ?>>)cfg);
            res.setTransitive(this.transitiveBootstrapContext, (class_5321<class_6796>)plc);
            return res;
        });
    }

    @NotNull
    private class_2975<FC, F> build() {
        FC config = this.createConfiguration();
        if (config == null) {
            throw new IllegalStateException("Feature configuration for " + String.valueOf(this.key.method_29177()) + " can not be null!");
        }
        return new class_2975(this.getFeature(), config);
    }

    void throwStateError(String message) {
        throw new IllegalStateException(message + (String)(this.key == null ? "" : "(" + String.valueOf(this.key.method_29177()) + ")"));
    }
}

