/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.impl.configured;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_4651;
import net.minecraft.class_4656;
import net.minecraft.class_4657;
import net.minecraft.class_5321;
import net.minecraft.class_6005;
import net.minecraft.class_7891;
import org.betterx.wover.block.api.BlockHelper;
import org.betterx.wover.feature.api.Features;
import org.betterx.wover.feature.api.configured.ConfiguredFeatureKey;
import org.betterx.wover.feature.api.configured.configurators.FacingBlock;
import org.betterx.wover.feature.api.features.PlaceBlockFeature;
import org.betterx.wover.feature.api.features.config.PlaceFacingBlockConfig;
import org.betterx.wover.feature.impl.configured.FeatureConfiguratorImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacingBlockImpl
extends FeatureConfiguratorImpl<PlaceFacingBlockConfig, PlaceBlockFeature<PlaceFacingBlockConfig>>
implements FacingBlock {
    private final class_6005.class_6006<class_2680> stateBuilder = class_6005.method_34971();
    class_2680 firstState;
    private int count = 0;
    private List<class_2350> directions = BlockHelper.HORIZONTAL;

    FacingBlockImpl(@Nullable class_7891<class_2975<?, ?>> ctx, @Nullable class_5321<class_2975<?, ?>> key) {
        super(ctx, key);
    }

    @Override
    public FacingBlock allHorizontal() {
        this.directions = BlockHelper.HORIZONTAL;
        return this;
    }

    @Override
    public FacingBlock allVertical() {
        this.directions = BlockHelper.VERTICAL;
        return this;
    }

    @Override
    public FacingBlock allDirections() {
        this.directions = BlockHelper.ALL;
        return this;
    }

    @Override
    public FacingBlock add(class_2248 block) {
        return this.add(block, 1);
    }

    @Override
    public FacingBlock add(class_2680 state) {
        return this.add(state, 1);
    }

    @Override
    public FacingBlock add(class_2248 block, int weight) {
        return this.add(block.method_9564(), weight);
    }

    @Override
    public FacingBlock add(class_2680 state, int weight) {
        if (this.firstState == null) {
            this.firstState = state;
        }
        ++this.count;
        this.stateBuilder.method_34975((Object)state, weight);
        return this;
    }

    @Override
    public FacingBlock addAllStates(class_2248 block, int weight) {
        Set states = BlockHelper.getPossibleStates((class_2248)block);
        states.forEach(s -> this.add((class_2680)s, Math.max(1, weight / states.size())));
        return this;
    }

    @Override
    public FacingBlock addAllStatesFor(class_2758 prop, class_2248 block, int weight) {
        Collection values = prop.method_11898();
        values.forEach(s -> this.add((class_2680)block.method_9564().method_11657((class_2769)prop, (Comparable)s), Math.max(1, weight / values.size())));
        return this;
    }

    @Override
    @NotNull
    public PlaceFacingBlockConfig createConfiguration() {
        class_4656 provider = null;
        if (this.count == 1) {
            provider = class_4656.method_38433((class_2680)this.firstState);
        } else {
            class_6005 list = this.stateBuilder.method_34974();
            if (!list.method_34993()) {
                provider = new class_4657(list);
            }
        }
        if (provider == null) {
            throw new IllegalStateException("Facing Blocks need a State Provider.");
        }
        return new PlaceFacingBlockConfig((class_4651)provider, this.directions);
    }

    @Override
    @NotNull
    protected PlaceBlockFeature<PlaceFacingBlockConfig> getFeature() {
        return (PlaceBlockFeature)Features.PLACE_BLOCK;
    }

    public static class Key
    extends ConfiguredFeatureKey<FacingBlock> {
        public Key(class_2960 id) {
            super(id);
        }

        @Override
        public FacingBlock bootstrap(@NotNull class_7891<class_2975<?, ?>> ctx) {
            return new FacingBlockImpl(ctx, this.key);
        }
    }
}

