/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.api.placed.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_4076;
import net.minecraft.class_5281;
import net.minecraft.class_5444;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6646;
import net.minecraft.class_6797;
import net.minecraft.class_6798;
import org.betterx.wover.block.api.BlockHelper;
import org.betterx.wover.block.api.predicate.BlockPredicates;
import org.betterx.wover.feature.impl.placed.modifiers.PlacementModifiersImpl;
import org.jetbrains.annotations.NotNull;

public class FindInDirection
extends class_6797 {
    public static final MapCodec<FindInDirection> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.method_36973((Codec)class_2350.field_29502.listOf()).optionalFieldOf("dir", List.of(class_2350.field_11033)).forGetter(a -> a.directions), (App)Codec.intRange((int)1, (int)32).optionalFieldOf("dist", (Object)12).forGetter(p -> p.maxSearchDistance), (App)Codec.BOOL.optionalFieldOf("random_select", (Object)true).forGetter(p -> p.randomSelect), (App)Codec.INT.optionalFieldOf("offset_in_dir", (Object)0).forGetter(p -> p.offsetInDir), (App)class_6646.field_35054.optionalFieldOf("surface_predicate", (Object)BlockPredicates.ONLY_GROUND).forGetter(p -> p.surfacePredicate)).apply((Applicative)instance, FindInDirection::new));
    private static final FindInDirection DOWN = new FindInDirection(class_2350.field_11033, 6, 0, BlockPredicates.ONLY_GROUND);
    private static final FindInDirection UP = new FindInDirection(class_2350.field_11036, 6, 0, BlockPredicates.ONLY_GROUND);
    private final List<class_2350> directions;
    private final int maxSearchDistance;
    private final int offsetInDir;
    private final boolean randomSelect;
    private final class_6017 provider;
    private final class_6646 surfacePredicate;

    public FindInDirection(class_2350 direction, int maxSearchDistance, int offsetInDir, class_6646 surfacePredicate) {
        this(List.of(direction), maxSearchDistance, false, offsetInDir, surfacePredicate);
    }

    public FindInDirection(List<class_2350> directions, int maxSearchDistance, int offsetInDir, class_6646 surfacePredicate) {
        this(directions, maxSearchDistance, directions.size() > 1, offsetInDir, surfacePredicate);
    }

    public FindInDirection(List<class_2350> directions, int maxSearchDistance, boolean randomSelect, int offsetInDir, class_6646 surfacePredicate) {
        this.directions = directions;
        this.maxSearchDistance = maxSearchDistance;
        this.provider = class_6019.method_35017((int)0, (int)(this.directions.size() - 1));
        this.randomSelect = randomSelect;
        this.offsetInDir = offsetInDir;
        this.surfacePredicate = surfacePredicate;
    }

    public static class_6797 down() {
        return DOWN;
    }

    public static class_6797 up() {
        return UP;
    }

    public static class_6797 down(int dist) {
        if (dist == FindInDirection.DOWN.maxSearchDistance && 0 == FindInDirection.DOWN.offsetInDir) {
            return DOWN;
        }
        return new FindInDirection(class_2350.field_11033, dist, 0, BlockPredicates.ONLY_GROUND);
    }

    public static class_6797 up(int dist) {
        if (dist == FindInDirection.UP.maxSearchDistance && 0 == FindInDirection.UP.offsetInDir) {
            return UP;
        }
        return new FindInDirection(class_2350.field_11036, dist, 0, BlockPredicates.ONLY_GROUND);
    }

    public static class_6797 down(int dist, int offset) {
        if (dist == FindInDirection.DOWN.maxSearchDistance && 0 == FindInDirection.DOWN.offsetInDir) {
            return DOWN;
        }
        return new FindInDirection(class_2350.field_11033, dist, offset, BlockPredicates.ONLY_GROUND);
    }

    public static class_6797 up(int dist, int offset) {
        if (dist == FindInDirection.UP.maxSearchDistance && offset == FindInDirection.UP.offsetInDir) {
            return UP;
        }
        return new FindInDirection(class_2350.field_11036, dist, offset, BlockPredicates.ONLY_GROUND);
    }

    public class_2350 randomDirection(class_5819 random) {
        return this.directions.get(this.provider.method_35008(random));
    }

    @NotNull
    public Stream<class_2338> method_14452(class_5444 placementContext, class_5819 randomSource, class_2338 blockPos) {
        Stream.Builder<class_2338> builder = Stream.builder();
        if (this.randomSelect) {
            this.submitSingle(placementContext, blockPos, builder, this.randomDirection(randomSource));
        } else {
            for (class_2350 d : this.directions) {
                this.submitSingle(placementContext, blockPos, builder, d);
            }
        }
        return builder.build();
    }

    private void submitSingle(class_5444 placementContext, class_2338 blockPos, Stream.Builder<class_2338> builder, class_2350 searchDirection) {
        class_2338.class_2339 POS = blockPos.method_25503();
        int searchDist = searchDirection == class_2350.field_11034 ? Math.min(this.maxSearchDistance, 15 - class_4076.method_18684((int)blockPos.method_10263())) : (searchDirection == class_2350.field_11039 ? Math.min(this.maxSearchDistance, class_4076.method_18684((int)blockPos.method_10263())) : (searchDirection == class_2350.field_11035 ? Math.min(this.maxSearchDistance, 15 - class_4076.method_18684((int)blockPos.method_10260())) : (searchDirection == class_2350.field_11043 ? Math.min(this.maxSearchDistance, class_4076.method_18684((int)blockPos.method_10260())) : this.maxSearchDistance)));
        if (BlockHelper.findOnSurroundingSurface((class_5281)placementContext.method_34383(), (class_2338.class_2339)POS, (class_2350)searchDirection, (int)searchDist, (class_6646)this.surfacePredicate)) {
            if (this.offsetInDir != 0) {
                builder.add((class_2338)POS.method_10104(searchDirection, this.offsetInDir));
            } else {
                builder.add((class_2338)POS);
            }
        }
    }

    @NotNull
    public class_6798<?> method_39615() {
        return PlacementModifiersImpl.SOLID_IN_DIR;
    }
}

