/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.api.placed.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_3542;
import net.minecraft.class_5444;
import net.minecraft.class_5819;
import net.minecraft.class_5862;
import net.minecraft.class_5863;
import net.minecraft.class_6017;
import net.minecraft.class_6797;
import net.minecraft.class_6798;
import org.betterx.wover.feature.impl.placed.modifiers.PlacementModifiersImpl;
import org.jetbrains.annotations.NotNull;

public class ExtendXYZ
extends class_6797 {
    public static final MapCodec<ExtendXYZ> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6017.method_35004((int)0, (int)16).fieldOf("radius").forGetter(cfg -> cfg.radius), (App)class_5863.method_33916((float)0.0f, (float)2.0f).optionalFieldOf("center_density", (Object)class_5862.method_33908((float)1.0f)).forGetter(cfg -> cfg.centerDensity), (App)class_5863.method_33916((float)0.0f, (float)2.0f).optionalFieldOf("border_density", (Object)class_5862.method_33908((float)0.05f)).forGetter(cfg -> cfg.borderDensity), (App)Codec.BOOL.optionalFieldOf("square", (Object)false).forGetter(cfg -> cfg.square), (App)class_5863.method_33916((float)0.0f, (float)30.0f).optionalFieldOf("height", (Object)class_5862.method_33908((float)1.0f)).forGetter(cfg -> cfg.heightScale), (App)HeightPropagation.CODEC.optionalFieldOf("height_propagation", (Object)HeightPropagation.NONE).forGetter(cfg -> cfg.heightPropagation)).apply((Applicative)instance, ExtendXYZ::new));
    private final class_6017 radius;
    private final class_5863 centerDensity;
    private final class_5863 borderDensity;
    private final boolean square;
    private final class_5863 heightScale;
    private final HeightPropagation heightPropagation;

    public ExtendXYZ(class_6017 radius, class_5863 centerDensity, class_5863 borderDensity, boolean square, class_5863 heightScale, HeightPropagation heightPropagation) {
        this.radius = radius;
        this.centerDensity = centerDensity;
        this.borderDensity = borderDensity;
        this.square = square;
        this.heightScale = heightScale;
        this.heightPropagation = heightPropagation;
    }

    public ExtendXYZ(class_6017 radius, class_5863 centerDensity, class_5863 borderDensity, boolean square) {
        this(radius, centerDensity, borderDensity, square, (class_5863)class_5862.method_33908((float)1.0f), HeightPropagation.NONE);
    }

    public static ExtendXYZ circle(class_6017 radius, class_5863 centerDensity, class_5863 borderDensity) {
        return new ExtendXYZ(radius, centerDensity, borderDensity, false);
    }

    public static ExtendXYZ spikedCircle(class_6017 radius, class_5863 centerDensity, class_5863 borderDensity, class_5863 heightScale) {
        return new ExtendXYZ(radius, centerDensity, borderDensity, false, heightScale, HeightPropagation.SPIKES_DOWN);
    }

    public static ExtendXYZ square(class_6017 radius, class_5863 centerDensity, class_5863 borderDensity) {
        return new ExtendXYZ(radius, centerDensity, borderDensity, true);
    }

    private static void propagateSphere(class_5819 randomSource, Stream.Builder<class_2338> builder, float maxR2, int maxDepth, int scale, float d0, float d1, float currentR2, float currentDensity, class_2338 pos, boolean didAdd) {
        int depth = (int)((float)maxDepth * (1.0f - currentR2 / maxR2));
        ExtendXYZ.propagateDown(randomSource, builder, d0, d1, currentDensity, pos, depth, scale);
    }

    private static void propagateSquare(class_5819 randomSource, Stream.Builder<class_2338> builder, float maxR2, int maxDepth, int scale, float d0, float d1, float currentR2, float currentDensity, class_2338 pos, boolean didAdd) {
        ExtendXYZ.propagateDown(randomSource, builder, d0, d1, currentDensity, pos, maxDepth, scale);
    }

    private static void propagateSpikesConnected(class_5819 randomSource, Stream.Builder<class_2338> builder, float maxR2, int maxDepth, int scale, float d0, float d1, float currentR2, float currentDensity, class_2338 pos, boolean didAdd) {
        if (!didAdd) {
            return;
        }
        ExtendXYZ.propagateDownConnected(randomSource, builder, d0, d1, currentDensity * currentDensity, pos, maxDepth, scale);
    }

    private static void propagateDownConnected(class_5819 randomSource, Stream.Builder<class_2338> builder, float d0, float d1, float currentDensity, class_2338 pos, int depth, int scale) {
        int depth2 = depth * depth;
        for (int y = 1; y <= depth; ++y) {
            float lambda = (float)(y * y) / (float)depth2;
            float densityDown = (d0 + (d1 - d0) * lambda) * currentDensity;
            if ((double)densityDown <= 0.001) {
                return;
            }
            if (randomSource.method_43057() > densityDown) {
                return;
            }
            builder.add(pos.method_10086(scale * y));
        }
    }

    private static void propagateDown(class_5819 randomSource, Stream.Builder<class_2338> builder, float d0, float d1, float currentDensity, class_2338 pos, int depth, int scale) {
        int depth2 = depth * depth;
        for (int y = 1; y <= depth; ++y) {
            float lambda = (float)(y * y) / (float)depth2;
            float densityDown = (d0 + (d1 - d0) * lambda) * currentDensity;
            if ((double)densityDown <= 0.001 || randomSource.method_43057() > densityDown) continue;
            builder.add(pos.method_10086(y * scale));
        }
    }

    @NotNull
    public Stream<class_2338> method_14452(class_5444 placementContext, class_5819 randomSource, class_2338 blockPos) {
        Stream.Builder<class_2338> builder = Stream.builder();
        int r = this.radius.method_35008(randomSource);
        float r2 = r * r;
        float d0 = this.centerDensity.method_33920(randomSource);
        float d1 = this.borderDensity.method_33920(randomSource);
        int height = (int)((float)r * this.heightScale.method_33920(randomSource));
        for (int x = -r; x <= r; ++x) {
            for (int z = -r; z <= r; ++z) {
                float currentR2 = x * x + z * z;
                if (!this.square && currentR2 > r2) continue;
                float lambda = currentR2 / r2;
                float density = d0 + (d1 - d0) * lambda;
                class_2338 now = blockPos.method_10069(x, 0, z);
                if (density >= 1.0f || density > 0.001f && density >= randomSource.method_43057()) {
                    builder.add(now);
                    this.heightPropagation.propagationFunction.propagate(randomSource, builder, r2, height, this.heightPropagation.scale, d0, d1, currentR2, density, now, true);
                    continue;
                }
                this.heightPropagation.propagationFunction.propagate(randomSource, builder, r2, height, this.heightPropagation.scale, d0, d1, currentR2, density, now, false);
            }
        }
        return builder.build();
    }

    @NotNull
    public class_6798<ExtendXYZ> method_39615() {
        return PlacementModifiersImpl.EXTEND_XZ;
    }

    public static enum HeightPropagation implements class_3542
    {
        NONE(1, (randomSource, builder, maxR2, maxDepth, scale1, d0, d1, currentR2, density, pos, didAdd) -> {}),
        BOX_DOWN(-1, ExtendXYZ::propagateSquare),
        BOX_UP(1, ExtendXYZ::propagateSquare),
        SPHERE_DOWN(-1, ExtendXYZ::propagateSphere),
        SPHERE_UP(1, ExtendXYZ::propagateSphere),
        SPIKES_DOWN(-1, ExtendXYZ::propagateSpikesConnected),
        SPIKES_UP(1, ExtendXYZ::propagateSpikesConnected);

        public static final Codec<HeightPropagation> CODEC;
        private final int scale;
        private final PropagationFunction propagationFunction;

        private HeightPropagation(int scale, PropagationFunction propagationFunction) {
            this.scale = scale;
            this.propagationFunction = propagationFunction;
        }

        @NotNull
        public String method_15434() {
            return this.name().toLowerCase();
        }

        static {
            CODEC = class_3542.method_28140(HeightPropagation::values);
        }
    }

    private static interface PropagationFunction {
        public void propagate(class_5819 var1, Stream.Builder<class_2338> var2, float var3, int var4, int var5, float var6, float var7, float var8, float var9, class_2338 var10, boolean var11);
    }
}

