/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.api.placed.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_5444;
import net.minecraft.class_5819;
import net.minecraft.class_6797;
import net.minecraft.class_6798;
import org.betterx.wover.block.api.BlockHelper;
import org.betterx.wover.feature.impl.placed.modifiers.PlacementModifiersImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class EveryLayer
extends class_6797 {
    private static final EveryLayer INSTANCE = new EveryLayer(Integer.MIN_VALUE, Integer.MAX_VALUE, true);
    private static final EveryLayer INSTANCE_MIN_4 = new EveryLayer(4, Integer.MAX_VALUE, true);
    private static final EveryLayer UNDER_INSTANCE = new EveryLayer(Integer.MIN_VALUE, Integer.MAX_VALUE, false);
    private static final EveryLayer UNDER_INSTANCE_MIN_4 = new EveryLayer(4, Integer.MAX_VALUE, false);
    public static final MapCodec<EveryLayer> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("min", (Object)Integer.MIN_VALUE).forGetter(o -> o.minHeight), (App)Codec.INT.optionalFieldOf("max", (Object)Integer.MAX_VALUE).forGetter(o -> o.maxHeight), (App)Codec.BOOL.optionalFieldOf("top", (Object)true).forGetter(o -> o.onTop)).apply((Applicative)instance, EveryLayer::new));
    @ApiStatus.Internal
    public static final MapCodec<EveryLayer> CODEC_LEGACY_UNDER = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("min", (Object)Integer.MIN_VALUE).forGetter(o -> o.minHeight), (App)Codec.INT.optionalFieldOf("max", (Object)Integer.MAX_VALUE).forGetter(o -> o.maxHeight), (App)Codec.BOOL.optionalFieldOf("top", (Object)false).forGetter(o -> o.onTop)).apply((Applicative)instance, EveryLayer::new));
    private final int minHeight;
    private final int maxHeight;
    private final boolean onTop;

    private EveryLayer(int minHeight, int maxHeight, boolean onTop) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.onTop = onTop;
    }

    public static EveryLayer on() {
        return INSTANCE;
    }

    public static EveryLayer onTopMin4() {
        return INSTANCE_MIN_4;
    }

    public static EveryLayer onTopInRange(int minHeight, int maxHeight) {
        return new EveryLayer(minHeight, maxHeight, true);
    }

    public static EveryLayer underneath() {
        return UNDER_INSTANCE;
    }

    public static EveryLayer underneathMin4() {
        return UNDER_INSTANCE_MIN_4;
    }

    public static EveryLayer underneathInRange(int minHeight, int maxHeight) {
        return new EveryLayer(minHeight, maxHeight, false);
    }

    @NotNull
    public Stream<class_2338> method_14452(class_5444 ctx, class_5819 random, class_2338 pos) {
        int layerY;
        Stream.Builder<class_2338> builder = Stream.builder();
        int z = pos.method_10260();
        int x = pos.method_10263();
        int levelHeight = ctx.method_30460(class_2902.class_2903.field_13197, x, z);
        int minLevelHeight = ctx.method_33868();
        int y = Math.min(levelHeight, this.maxHeight);
        int minHeight = Math.max(minLevelHeight, this.minHeight);
        do {
            int n = layerY = this.onTop ? EveryLayer.findOnGroundYPosition(ctx, x, y, z, minHeight) : EveryLayer.findUnderGroundYPosition(ctx, x, y, z, minHeight);
            if (layerY == Integer.MAX_VALUE) continue;
            builder.add(new class_2338(x, layerY, z));
            y = layerY - 1;
        } while (layerY != Integer.MAX_VALUE);
        return builder.build();
    }

    @NotNull
    public class_6798<EveryLayer> method_39615() {
        return PlacementModifiersImpl.EVERY_LAYER;
    }

    private static int findOnGroundYPosition(class_5444 ctx, int x, int startY, int z, int minHeight) {
        class_2338.class_2339 mPos = new class_2338.class_2339(x, startY, z);
        class_2680 nowState = ctx.method_30461((class_2338)mPos);
        for (int y = startY; y >= minHeight + 1; --y) {
            mPos.method_33098(y - 1);
            class_2680 belowState = ctx.method_30461((class_2338)mPos);
            if (BlockHelper.isTerrain((class_2680)belowState) && BlockHelper.isFreeOrFluid((class_2680)nowState) && !belowState.method_27852(class_2246.field_9987)) {
                return mPos.method_10264() + 1;
            }
            nowState = belowState;
        }
        return Integer.MAX_VALUE;
    }

    private static int findUnderGroundYPosition(class_5444 ctx, int x, int startY, int z, int minHeight) {
        class_2338.class_2339 mPos = new class_2338.class_2339(x, startY, z);
        class_2680 nowState = ctx.method_30461((class_2338)mPos);
        for (int y = startY; y >= minHeight + 1; --y) {
            mPos.method_33098(y - 1);
            class_2680 belowState = ctx.method_30461((class_2338)mPos);
            if (BlockHelper.isTerrain((class_2680)nowState) && BlockHelper.isFreeOrFluid((class_2680)belowState) && !nowState.method_27852(class_2246.field_9987)) {
                return mPos.method_10264();
            }
            nowState = belowState;
        }
        return Integer.MAX_VALUE;
    }
}

