/*
 * Decompiled with CFR 0.152.
 */
package lancet_.tameable_foxes.mixin;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import lancet_.tameable_foxes.TameableFoxesConfig;
import lancet_.tameable_foxes.goals.FoxAttackWithOwnerGoal;
import lancet_.tameable_foxes.goals.FoxFollowPlayerGoal;
import lancet_.tameable_foxes.goals.FoxPerchAndSearchGoal;
import lancet_.tameable_foxes.goals.FoxSeekShelterGoal;
import lancet_.tameable_foxes.goals.FoxSitGoal;
import lancet_.tameable_foxes.goals.FoxStalkPreyGoal;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Fox.class})
public class FoxMixin
extends Animal
implements OwnableEntity {
    @Unique
    Fox fox;

    public FoxMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.fox = (Fox)entityType;
    }

    public boolean isFood(ItemStack stack) {
        return TameableFoxesConfig.FOX_BREEDING_ITEMS.contains(stack.getItem());
    }

    public boolean canMate(@NotNull Animal otherAnimal) {
        if (otherAnimal instanceof Fox) {
            Fox otherFox = (Fox)otherAnimal;
            if (otherAnimal != this.fox) {
                boolean isOtherFoxTamed;
                boolean bl = isOtherFoxTamed = ((Optional)otherFox.getEntityData().get(Fox.DATA_TRUSTED_ID_0)).orElse(null) != null;
                if (this.isTame() == isOtherFoxTamed) {
                    return !this.fox.isSitting() && this.isInLove() && this.fox.isInLove();
                }
            }
        }
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob otherParent) {
        Fox fox = (Fox)EntityType.FOX.create((Level)level);
        if (fox != null) {
            fox.setVariant(this.random.nextBoolean() ? this.fox.getVariant() : ((Fox)otherParent).getVariant());
            if (this.getOwner() != null) {
                fox.getEntityData().set(Fox.DATA_TRUSTED_ID_0, Optional.ofNullable(this.getOwnerUUID()));
            }
        }
        return fox;
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.fox == null) {
            this.fox = (Fox)this;
        }
        UUID ownerUUID = ((Optional)this.fox.getEntityData().get(Fox.DATA_TRUSTED_ID_0)).orElse(null);
        InteractionResult interactionResult = super.mobInteract(player, hand);
        ItemStack itemStack = player.getItemInHand(hand);
        if (ownerUUID == null && this.isTamingItem(itemStack) && (TameableFoxesConfig.config.foxesTameDirectly || !this.isFood(itemStack))) {
            itemStack.consume(1, (LivingEntity)player);
            this.fox.setInLove(player);
            this.setFoxOwner(player.getUUID());
            if (this.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isFood(itemStack)) {
            return interactionResult;
        }
        if (!player.getUUID().equals(ownerUUID)) {
            return InteractionResult.PASS;
        }
        if (this.fox.isSleeping()) {
            this.fox.setSleeping(false);
        } else {
            this.fox.setSitting(!this.fox.isSitting());
            this.jumping = false;
            this.navigation.stop();
            this.setTarget(null);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean handleLeashAtDistance(@NotNull Entity leashHolder, float distance) {
        if (this.fox.isSitting()) {
            if (distance > 10.0f) {
                this.dropLeash(true, true);
            }
            return false;
        }
        return super.handleLeashAtDistance(leashHolder, distance);
    }

    @Unique
    private boolean isTamingItem(ItemStack itemStack) {
        return TameableFoxesConfig.FOX_TAMING_ITEMS.contains(itemStack.getItem());
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    public void addAiGoals(CallbackInfo ci) {
        if (this.fox == null) {
            this.fox = (Fox)this;
        }
        this.fox.goalSelector.getAvailableGoals().removeIf(goal -> goal.getGoal() instanceof Fox.SeekShelterGoal || goal.getGoal() instanceof Fox.PerchAndSearchGoal);
        this.fox.landTargetGoal = new NearestAttackableTargetGoal((Mob)this.fox, Animal.class, 10, false, false, entity -> (entity instanceof Chicken || entity instanceof Rabbit) && !this.isTame());
        this.fox.turtleEggTargetGoal = new NearestAttackableTargetGoal((Mob)this.fox, Turtle.class, 10, false, false, e -> e instanceof Turtle && e.isBaby() && !e.isInWater() && !this.isTame());
        this.fox.fishTargetGoal = new NearestAttackableTargetGoal((Mob)this.fox, AbstractFish.class, 20, false, false, entity -> entity instanceof AbstractSchoolingFish && !this.isTame());
        this.fox.goalSelector.addGoal(1, (Goal)new FoxSitGoal(this.fox));
        this.fox.goalSelector.addGoal(1, (Goal)new FoxAttackWithOwnerGoal(this.fox));
        this.fox.goalSelector.addGoal(1, (Goal)new TemptGoal((PathfinderMob)this.fox, 0.75, (Predicate)Ingredient.of(TameableFoxesConfig.getFoxTemptingItemStacks()), false));
        this.fox.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this.fox, Player.class, 16.0f, 1.6, 1.4, e -> Fox.AVOID_PLAYERS.test(e) && !this.isTame() && !this.fox.isAggressive()));
        this.fox.goalSelector.addGoal(5, (Goal)new FoxStalkPreyGoal(this.fox));
        this.fox.goalSelector.addGoal(6, (Goal)new FoxFollowPlayerGoal(this.fox, 1.0, 10.0f, 2.0f));
        this.fox.goalSelector.addGoal(6, (Goal)new FoxSeekShelterGoal(1.25, this.fox));
        this.fox.goalSelector.addGoal(13, (Goal)new FoxPerchAndSearchGoal(this.fox));
    }

    @Unique
    public void setFoxOwner(UUID newOwnerUUID) {
        assert (this.fox != null);
        this.fox.getEntityData().set(Fox.DATA_TRUSTED_ID_0, Optional.of(newOwnerUUID));
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.fox.getEntityData().get(Fox.DATA_TRUSTED_ID_0)).orElse(null);
    }

    @Unique
    public boolean isTame() {
        return this.getOwnerUUID() != null;
    }

    public void die(@NotNull DamageSource cause) {
        Component deathMessage = this.getCombatTracker().getDeathMessage();
        super.die(cause);
        if (this.dead && !this.level().isClientSide && this.level().getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES) && this.getOwner() instanceof ServerPlayer) {
            this.getOwner().sendSystemMessage(deathMessage);
        }
    }
}

