/*
 * Decompiled with CFR 0.152.
 */
package lancet_.tameable_foxes.goals;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Fox;

public class FoxStalkPreyGoal
extends Goal {
    Fox fox;

    public FoxStalkPreyGoal(Fox fox) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.fox = fox;
    }

    public boolean canUse() {
        if (this.fox.isSleeping()) {
            return false;
        }
        LivingEntity livingentity = this.fox.getTarget();
        return livingentity != null && livingentity.isAlive() && Fox.STALKABLE_PREY.test(livingentity) && this.fox.distanceToSqr((Entity)livingentity) > 36.0 && !this.fox.isCrouching() && !this.fox.isInterested() && !this.fox.jumping;
    }

    public void start() {
        this.fox.setSitting(false);
        this.fox.setFaceplanted(false);
    }

    public void stop() {
        LivingEntity livingentity = this.fox.getTarget();
        if (livingentity != null && Fox.isPathClear((Fox)this.fox, (LivingEntity)livingentity)) {
            this.fox.setIsInterested(true);
            this.fox.setIsCrouching(true);
            this.fox.getNavigation().stop();
            this.fox.getLookControl().setLookAt((Entity)livingentity, (float)this.fox.getMaxHeadYRot(), (float)this.fox.getMaxHeadXRot());
        } else {
            this.fox.setIsInterested(false);
            this.fox.setIsCrouching(false);
        }
    }

    public void tick() {
        LivingEntity livingentity = this.fox.getTarget();
        if (livingentity != null) {
            this.fox.getLookControl().setLookAt((Entity)livingentity, (float)this.fox.getMaxHeadYRot(), (float)this.fox.getMaxHeadXRot());
            if (this.fox.distanceToSqr((Entity)livingentity) <= 36.0) {
                this.fox.setIsInterested(true);
                this.fox.setIsCrouching(true);
                this.fox.getNavigation().stop();
            } else {
                this.fox.getNavigation().moveTo((Entity)livingentity, 1.5);
            }
        }
    }
}

