/*
 * Decompiled with CFR 0.152.
 */
package lancet_.tameable_foxes.goals;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Fox;

public class FoxSitGoal
extends Goal {
    private final Fox fop;
    private LivingEntity owner = null;

    public FoxSitGoal(Fox entity) {
        this.fop = entity;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean canContinueToUse() {
        return this.fop.isSitting() && !this.fop.isLeashed();
    }

    public boolean canUse() {
        if (this.fop.isInWaterOrBubble()) {
            return false;
        }
        if (!this.fop.onGround()) {
            return false;
        }
        UUID uuid = ((Optional)this.fop.getEntityData().get(Fox.DATA_TRUSTED_ID_0)).orElse(null);
        if (uuid == null) {
            return false;
        }
        ServerPlayer livingEntity = Objects.requireNonNull(this.fop.getServer()).getPlayerList().getPlayer(uuid);
        if (livingEntity == null) {
            return true;
        }
        if (this.fop.distanceToSqr((Entity)livingEntity) < 144.0 && livingEntity.getLastAttacker() != null) {
            return false;
        }
        this.owner = livingEntity;
        return this.fop.isSitting();
    }

    public void start() {
        this.fop.setSpeed(0.0f);
        this.fop.getNavigation().stop();
    }
}

