/*
 * Decompiled with CFR 0.152.
 */
package lancet_.tameable_foxes.goals;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Fox;

public class FoxPerchAndSearchGoal
extends Goal {
    private double relX;
    private double relZ;
    private int lookTime;
    private int looksRemaining;
    Fox fox;
    private final TargetingConditions alertableTargeting;

    public FoxPerchAndSearchGoal(Fox fox) {
        this.fox = fox;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.alertableTargeting = TargetingConditions.forCombat().range(12.0).ignoreLineOfSight().selector((Predicate)new Fox.FoxAlertableEntitiesSelector(this.fox));
    }

    public boolean canUse() {
        return this.fox.getLastHurtByMob() == null && this.fox.getRandom().nextFloat() < 0.02f && !this.fox.isSleeping() && this.fox.getTarget() == null && this.fox.getNavigation().isDone() && !this.alertable() && !this.fox.isPouncing() && !this.fox.isCrouching();
    }

    public boolean canContinueToUse() {
        return this.looksRemaining > 0;
    }

    public void start() {
        this.resetLook();
        this.looksRemaining = 2 + this.fox.getRandom().nextInt(3);
        this.fox.setSitting(true);
        this.fox.getNavigation().stop();
    }

    public void stop() {
        this.fox.setSitting(false);
    }

    public void tick() {
        --this.lookTime;
        if (this.lookTime <= 0) {
            --this.looksRemaining;
            this.resetLook();
        }
        this.fox.getLookControl().setLookAt(this.fox.getX() + this.relX, this.fox.getEyeY(), this.fox.getZ() + this.relZ, (float)this.fox.getMaxHeadYRot(), (float)this.fox.getMaxHeadXRot());
    }

    private void resetLook() {
        double d0 = Math.PI * 2 * this.fox.getRandom().nextDouble();
        this.relX = Math.cos(d0);
        this.relZ = Math.sin(d0);
        this.lookTime = this.adjustedTickDelay(80 + this.fox.getRandom().nextInt(20));
    }

    protected boolean alertable() {
        return !this.fox.level().getNearbyEntities(LivingEntity.class, this.alertableTargeting, (LivingEntity)this.fox, this.fox.getBoundingBox().inflate(12.0, 6.0, 12.0)).isEmpty();
    }
}

