/*
 * Decompiled with CFR 0.152.
 */
package lancet_.tameable_foxes.goals;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class FoxFollowPlayerGoal
extends Goal {
    private final Fox fop;
    private LivingEntity owner;
    private final double speed;
    private final float minDistance;
    private final float maxDistance;
    private int updateCountdownTicks;
    private final PathNavigation navigation;
    private float oldWaterPathfindingPenalty;

    public FoxFollowPlayerGoal(Fox entity, double speed, float minDistance, float maxDistance) {
        this.fop = entity;
        this.navigation = this.fop.getNavigation();
        this.speed = speed;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canContinueToUse() {
        if (this.fop.isSitting() || this.fop.isSleeping()) {
            return false;
        }
        return !(this.fop.distanceToSqr((Entity)this.owner) <= (double)(this.maxDistance * this.maxDistance));
    }

    public boolean canUse() {
        UUID uuid = ((Optional)this.fop.getEntityData().get(Fox.DATA_TRUSTED_ID_0)).orElse(null);
        if (uuid == null) {
            return false;
        }
        ServerPlayer livingEntity = Objects.requireNonNull(this.fop.getServer()).getPlayerList().getPlayer(uuid);
        if (livingEntity == null) {
            return false;
        }
        if (this.fop.isSitting()) {
            return false;
        }
        if (livingEntity.isSpectator()) {
            return false;
        }
        if (this.fop.distanceToSqr((Entity)livingEntity) < (double)(this.minDistance * this.minDistance)) {
            return false;
        }
        this.owner = livingEntity;
        return true;
    }

    public void start() {
        this.updateCountdownTicks = 0;
        this.oldWaterPathfindingPenalty = this.fop.getPathfindingMalus(PathType.WATER);
        this.fop.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.owner = null;
        this.navigation.stop();
        this.fop.setPathfindingMalus(PathType.WATER, this.oldWaterPathfindingPenalty);
    }

    public void tick() {
        this.fop.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.fop.getMaxHeadXRot());
        if (--this.updateCountdownTicks > 0) {
            return;
        }
        this.updateCountdownTicks = this.adjustedTickDelay(10);
        if (this.fop.distanceToSqr((Entity)this.owner) >= 144.0) {
            this.tryTeleport();
        } else {
            this.navigation.moveTo((Entity)this.owner, this.speed);
        }
    }

    private void tryTeleport() {
        BlockPos blockPos = this.owner.getOnPos();
        for (int i = 0; i < 10; ++i) {
            int j = this.getRandomInt(-3, 3);
            int k = this.getRandomInt(-1, 1);
            int l = this.getRandomInt(-3, 3);
            boolean bl = this.tryTeleportTo(blockPos.getX() + j, blockPos.getY() + k, blockPos.getZ() + l);
            if (!bl) continue;
            return;
        }
    }

    private boolean tryTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.getX()) < 2.0 && Math.abs((double)z - this.owner.getZ()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.fop.lerpPositionAndRotationStep(1, (double)x + 0.5, (double)y, (double)z + 0.5, (double)this.fop.getXRot(), (double)this.fop.getYRot());
        this.navigation.stop();
        return true;
    }

    private boolean canTeleportTo(BlockPos pos) {
        PathType pathNodeType = WalkNodeEvaluator.getPathTypeStatic((Mob)this.fop, (BlockPos)pos);
        if (pathNodeType != PathType.WALKABLE) {
            return false;
        }
        BlockState blockState = this.fop.getCommandSenderWorld().getBlockState(pos.below());
        BlockPos blockPos = pos.subtract((Vec3i)this.fop.blockPosition());
        return this.fop.getCommandSenderWorld().noCollision((Entity)this.fop, this.fop.getBoundingBox().move(blockPos));
    }

    private int getRandomInt(int min, int max) {
        return this.fop.getRandom().nextInt(max - min + 1) + min;
    }
}

