/*
 * Decompiled with CFR 0.152.
 */
package lancet_.tameable_foxes.goals;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Fox;

public class FoxAttackWithOwnerGoal
extends TargetGoal {
    private final Fox fop;
    private LivingEntity attacking;
    private int lastAttackTime;

    public FoxAttackWithOwnerGoal(Fox tameable) {
        super((Mob)tameable, false);
        this.fop = tameable;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        if (this.fop.isSitting()) {
            return false;
        }
        UUID uuid = ((Optional)this.fop.getEntityData().get(Fox.DATA_TRUSTED_ID_0)).orElse(null);
        if (uuid == null) {
            return false;
        }
        ServerPlayer livingEntity = Objects.requireNonNull(this.fop.getServer()).getPlayerList().getPlayer(uuid);
        if (livingEntity == null) {
            return false;
        }
        this.attacking = livingEntity.getLastAttacker();
        int i = livingEntity.getLastHurtByMobTimestamp();
        return i != this.lastAttackTime && this.canAttack(this.attacking, TargetingConditions.DEFAULT);
    }

    public void start() {
        ServerPlayer livingEntity;
        this.mob.setTarget(this.attacking);
        UUID uuid = ((Optional)this.fop.getEntityData().get(Fox.DATA_TRUSTED_ID_0)).orElse(null);
        if (uuid != null && (livingEntity = Objects.requireNonNull(this.fop.getServer()).getPlayerList().getPlayer(uuid)) != null) {
            this.lastAttackTime = livingEntity.getLastHurtByMobTimestamp();
        }
        super.start();
    }
}

