/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.configlib;

import com.supermartijn642.configlib.ConfigEntry;
import com.supermartijn642.configlib.ConfigFile;
import com.supermartijn642.configlib.ConfigLib;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class ModConfig<S> {
    private final String modid;
    private final String identifier;
    private final ConfigFile<S> configFile;
    private final List<Entry<?, S>> entries;
    private final Map<String, Entry<?, S>> entriesByPath = new HashMap();
    private final List<Entry<?, S>> correctSideEntries = new ArrayList();
    private final List<Entry<?, S>> updatableEntries = new ArrayList();
    private final List<Entry<?, S>> syncableEntries = new ArrayList();
    private final List<Pair<String[], String>> categoryComments;
    private final boolean shouldBeSynced;

    public ModConfig(String modid, String identifier, ConfigFile<S> configFile, List<Entry<?, S>> configEntries, List<Pair<String[], String>> categoryComments) {
        this.modid = modid;
        this.identifier = identifier;
        this.configFile = configFile;
        this.entries = Collections.unmodifiableList(configEntries);
        this.categoryComments = Collections.unmodifiableList(categoryComments);
        boolean shouldBeSynced = false;
        for (Entry<?, S> entry : this.entries) {
            if (!entry.configEntry.shouldBeSynced()) continue;
            shouldBeSynced = true;
        }
        this.shouldBeSynced = shouldBeSynced;
    }

    public void initialize() {
        boolean isClientSide = ConfigLib.isClientEnvironment();
        for (Entry<?, S> entry2 : this.entries) {
            if (isClientSide ? entry2.configEntry.isServerOnly() : entry2.configEntry.isClientOnly()) {
                entry2.wrongSide = true;
                continue;
            }
            this.correctSideEntries.add(entry2);
            this.entriesByPath.put(entry2.combinedPath, entry2);
            if (!entry2.configEntry.requiresGameRestart()) {
                this.updatableEntries.add(entry2);
            }
            if (!entry2.configEntry.shouldBeSynced()) continue;
            this.syncableEntries.add(entry2);
        }
        this.configFile.readFile();
        this.correctSideEntries.forEach(this::readEntryValue);
        this.configFile.clearValues();
        for (Map.Entry entry3 : this.categoryComments) {
            this.configFile.setComment((String[])entry3.getKey(), (String)entry3.getValue());
        }
        for (Entry<?, S> entry4 : this.correctSideEntries) {
            this.configFile.setComment(entry4.path, entry4.configEntry.getComment());
            this.configFile.setAllowedValuesHint(entry4.path, entry4.configEntry.getAllowedValuesHint());
            this.writeEntryValue(entry4);
        }
        this.configFile.writeFile();
        this.configFile.startTrackingFile();
        this.correctSideEntries.forEach(entry -> {
            entry.hasBeenInitialized = true;
        });
    }

    private void updateValues() {
        this.updatableEntries.forEach(this::readEntryValue);
    }

    private <T> void writeEntryValue(Entry<T, S> entry) {
        Object serialized = entry.configEntry.serialize(entry.value);
        if (serialized == null) {
            ConfigLib.LOGGER.error("Failed to serialize config value '" + String.valueOf(entry.value) + "' for '" + String.join((CharSequence)",", entry.path) + "' in config from " + this.modid + "!");
        } else {
            this.configFile.setValue(entry.path, serialized);
        }
    }

    private <T> void readEntryValue(Entry<T, S> entry) {
        Object value;
        S serialized = this.configFile.getValue(entry.path);
        entry.value = serialized == null ? entry.configEntry.defaultValue() : ((value = entry.configEntry.deserialize(serialized)) == null || !entry.configEntry.validateValue(value) ? entry.configEntry.defaultValue() : value);
    }

    public String getModid() {
        return this.modid;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void onJoinGame() {
        this.updateValues();
    }

    public void onLeaveGame() {
        this.clearSyncedValues();
    }

    public boolean hasSyncableEntries() {
        return this.shouldBeSynced;
    }

    public void writeSyncableEntries(ByteBuf buffer) {
        buffer.writeInt(this.syncableEntries.size());
        for (Entry<?, S> entry : this.syncableEntries) {
            this.writeSyncableEntry(buffer, entry);
        }
    }

    private <T> void writeSyncableEntry(ByteBuf buffer, Entry<T, S> entry) {
        byte[] pathBytes = entry.combinedPath.getBytes(StandardCharsets.UTF_8);
        buffer.writeInt(pathBytes.length);
        buffer.writeBytes(pathBytes);
        byte[] bytes = null;
        try {
            bytes = entry.configEntry.write(entry.value);
        }
        catch (Exception e) {
            ConfigLib.LOGGER.error("Failed to write synced config value '" + String.valueOf(entry.value) + "' for '" + String.join((CharSequence)",", entry.path) + "' in config from " + this.modid + "!", (Throwable)e);
        }
        if (bytes == null) {
            buffer.writeInt(-1);
        } else {
            buffer.writeInt(bytes.length);
            buffer.writeBytes(bytes);
        }
    }

    public void readSyncableValues(ByteBuf buffer) {
        int entryCount = buffer.readInt();
        for (int i = 0; i < entryCount; ++i) {
            byte[] pathBytes = new byte[Math.max(buffer.readInt(), 0)];
            buffer.readBytes(pathBytes);
            String combinedPath = new String(pathBytes, StandardCharsets.UTF_8);
            int valueByteCount = buffer.readInt();
            byte[] valueBytes = new byte[Math.max(valueByteCount, 0)];
            buffer.readBytes(valueBytes);
            Entry<?, S> entry = this.entriesByPath.get(combinedPath);
            if (entry == null) {
                ConfigLib.LOGGER.error("Received synced config value for unknown entry '" + combinedPath + "' in config from " + this.modid + "!");
                continue;
            }
            if (!entry.configEntry.shouldBeSynced()) {
                ConfigLib.LOGGER.error("Received synced config value for entry which should not be synced '" + combinedPath + "' in config from " + this.modid + "!");
                continue;
            }
            this.readSyncableEntry(valueByteCount < 0 ? null : ByteBuffer.wrap(valueBytes), entry);
        }
    }

    private <T> void readSyncableEntry(ByteBuffer buffer, Entry<T, S> entry) {
        Object value;
        if (buffer == null) {
            entry.syncedValue = entry.configEntry.defaultValue();
            return;
        }
        try {
            value = entry.configEntry.read(buffer);
        }
        catch (Exception e) {
            ConfigLib.LOGGER.error("Failed to read synced config value for entry '" + String.join((CharSequence)",", entry.path) + "' in config from " + this.modid + "!", (Throwable)e);
            entry.syncedValue = entry.configEntry.defaultValue();
            return;
        }
        if (value == null) {
            ConfigLib.LOGGER.error("Failed to read synced config value for entry '" + String.join((CharSequence)",", entry.path) + "' in config from " + this.modid + "!");
            entry.syncedValue = entry.configEntry.defaultValue();
            return;
        }
        if (!entry.configEntry.validateValue(value)) {
            ConfigLib.LOGGER.error("Received invalid synced config value '" + String.valueOf(entry.value) + "' for entry '" + String.join((CharSequence)",", entry.path) + "' from network in config from " + this.modid + "!");
            entry.syncedValue = entry.configEntry.defaultValue();
            return;
        }
        entry.syncedValue = value;
    }

    private void clearSyncedValues() {
        this.syncableEntries.forEach(entry -> {
            entry.syncedValue = null;
        });
    }

    protected static class Entry<T, S> {
        protected final String[] path;
        protected final String combinedPath;
        protected final ConfigEntry<T, S> configEntry;
        private boolean hasBeenInitialized;
        private boolean wrongSide;
        private T value;
        private T syncedValue;

        Entry(String[] path, ConfigEntry<T, S> configEntry) {
            this.path = path;
            this.combinedPath = String.join((CharSequence)".", path);
            this.configEntry = configEntry;
        }

        public T getValue() {
            if (!this.hasBeenInitialized) {
                throw new IllegalStateException("Config has not yet been initialized!");
            }
            if (this.wrongSide) {
                throw new IllegalStateException("Entry " + String.join((CharSequence)".", this.path) + " is " + (this.configEntry.isClientOnly() ? "client" : "server") + " side only!");
            }
            return this.syncedValue != null ? this.syncedValue : this.value;
        }
    }

    @Deprecated
    public static enum Type {
        CLIENT,
        SERVER,
        COMMON;

    }
}

