/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.renderlayers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.accessor.PlayerEntityModelAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.api.LayerFeatureTransformerAPI;
import dev.tr7zw.skinlayers.api.Mesh;
import dev.tr7zw.skinlayers.api.OffsetProvider;
import dev.tr7zw.skinlayers.api.PlayerData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;

public class CustomLayerFeatureRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final Minecraft mc = Minecraft.getInstance();
    private final List<Layer> bodyLayers = new ArrayList<Layer>();
    private final boolean thinArms = ((PlayerEntityModelAccessor)this.getParentModel()).hasThinArms();

    public CustomLayerFeatureRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderLayerParent) {
        super(renderLayerParent);
        this.bodyLayers.add(new Layer(PlayerData::getHeadMesh, PlayerModelPart.HAT, OffsetProvider.HEAD, () -> ((PlayerModel)this.getParentModel()).head, player -> {
            ItemStack itemStack = player.getItemBySlot(EquipmentSlot.HEAD);
            if (itemStack != null && SkinLayersModBase.hideHeadLayers.contains(itemStack.getItem())) {
                return false;
            }
            return SkinLayersModBase.config.enableHat;
        }));
        this.bodyLayers.add(new Layer(PlayerData::getLeftLegMesh, PlayerModelPart.LEFT_PANTS_LEG, OffsetProvider.LEFT_LEG, () -> ((PlayerModel)this.getParentModel()).leftLeg, player -> SkinLayersModBase.config.enableLeftPants));
        this.bodyLayers.add(new Layer(PlayerData::getRightLegMesh, PlayerModelPart.RIGHT_PANTS_LEG, OffsetProvider.RIGHT_LEG, () -> ((PlayerModel)this.getParentModel()).rightLeg, player -> SkinLayersModBase.config.enableRightPants));
        this.bodyLayers.add(new Layer(PlayerData::getLeftArmMesh, PlayerModelPart.LEFT_SLEEVE, this.thinArms ? OffsetProvider.LEFT_ARM_SLIM : OffsetProvider.LEFT_ARM, () -> ((PlayerModel)this.getParentModel()).leftArm, player -> SkinLayersModBase.config.enableLeftSleeve));
        this.bodyLayers.add(new Layer(PlayerData::getRightArmMesh, PlayerModelPart.RIGHT_SLEEVE, this.thinArms ? OffsetProvider.RIGHT_ARM_SLIM : OffsetProvider.RIGHT_ARM, () -> ((PlayerModel)this.getParentModel()).rightArm, player -> SkinLayersModBase.config.enableRightSleeve));
        this.bodyLayers.add(new Layer(PlayerData::getTorsoMesh, PlayerModelPart.JACKET, OffsetProvider.BODY, () -> ((PlayerModel)this.getParentModel()).body, player -> SkinLayersModBase.config.enableJacket));
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, AbstractClientPlayer player, float f, float g, float h, float j, float k, float l) {
        if (SkinLayersModBase.config.compatibilityMode || player.isInvisible()) {
            return;
        }
        if (CustomLayerFeatureRenderer.mc.level == null) {
            return;
        }
        if (player.distanceToSqr(CustomLayerFeatureRenderer.mc.gameRenderer.getMainCamera().getPosition()) > (double)(SkinLayersModBase.config.renderDistanceLOD * SkinLayersModBase.config.renderDistanceLOD)) {
            return;
        }
        PlayerSettings settings = (PlayerSettings)player;
        if (!SkinUtil.setup3dLayers(player, settings, this.thinArms)) {
            return;
        }
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)player.getSkin().texture(), (boolean)true));
        int m = LivingEntityRenderer.getOverlayCoords((LivingEntity)player, (float)0.0f);
        this.renderLayers(player, settings, poseStack, vertexConsumer, i, m);
    }

    public void renderLayers(AbstractClientPlayer abstractClientPlayer, PlayerSettings settings, PoseStack matrixStack, VertexConsumer vertices, int light, int overlay) {
        for (Layer layer : this.bodyLayers) {
            Mesh mesh = layer.meshGetter.apply(settings);
            if (mesh == null || !abstractClientPlayer.isModelPartShown(layer.modelPart) || !layer.vanillaGetter.get().visible || !layer.configGetter.apply(abstractClientPlayer).booleanValue()) continue;
            matrixStack.pushPose();
            LayerFeatureTransformerAPI.getTransformer().transform(abstractClientPlayer, matrixStack, layer.vanillaGetter.get());
            layer.vanillaGetter.get().translateAndRotate(matrixStack);
            layer.offset.applyOffset(matrixStack, mesh);
            mesh.render(layer.vanillaGetter.get(), matrixStack, vertices, light, overlay, -1);
            matrixStack.popPose();
        }
    }

    private static class Layer {
        private final Function<PlayerSettings, Mesh> meshGetter;
        private final PlayerModelPart modelPart;
        private final OffsetProvider offset;
        private final Supplier<ModelPart> vanillaGetter;
        private final Function<AbstractClientPlayer, Boolean> configGetter;

        @Generated
        public Layer(Function<PlayerSettings, Mesh> meshGetter, PlayerModelPart modelPart, OffsetProvider offset, Supplier<ModelPart> vanillaGetter, Function<AbstractClientPlayer, Boolean> configGetter) {
            this.meshGetter = meshGetter;
            this.modelPart = modelPart;
            this.offset = offset;
            this.vanillaGetter = vanillaGetter;
            this.configGetter = configGetter;
        }
    }
}

