/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.tag.impl;

import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.entrypoint.LibWoverTag;
import org.betterx.wover.events.api.Event;
import org.betterx.wover.events.impl.EventImpl;
import org.betterx.wover.tag.api.TagRegistry;
import org.betterx.wover.tag.api.event.OnBoostrapTags;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.jetbrains.annotations.Nullable;

public abstract class TagRegistryImpl<T, P extends TagBootstrapContext<T>>
implements TagRegistry<T, P> {
    private final ResourceKey<? extends Registry<T>> registryKey;
    final ConcurrentLinkedQueue<TagKey<T>> tags = new ConcurrentLinkedQueue();
    @Nullable
    final TagRegistry.LocationProvider<T> locationProvider;
    public final String directory;
    private final EventImpl<OnBoostrapTags<T, P>> BOOTSTRAP_EVENT;

    protected TagRegistryImpl(ResourceKey<? extends Registry<T>> registryKey, String directory, TagRegistry.LocationProvider<T> locationProvider) {
        this.registryKey = registryKey;
        this.directory = directory;
        this.locationProvider = locationProvider;
        this.BOOTSTRAP_EVENT = new EventImpl("TAG_BOOTSTRAP_EVENT (" + directory + ")");
    }

    @Override
    public TagKey<T> makeWorldWeaverTag(String name) {
        return this.makeTag(LibWoverTag.C.mk(name));
    }

    @Override
    public TagKey<T> makeCommonTag(String name) {
        return this.makeTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
    }

    @Override
    public TagKey<T> makeFabricTag(String name) {
        return this.makeTag(ResourceLocation.fromNamespaceAndPath((String)"fabric", (String)name));
    }

    @Override
    public TagKey<T> makeTag(ModCore mod, String name) {
        return this.makeTag(mod.id(name));
    }

    @Override
    public TagKey<T> makeTag(ResourceLocation id) {
        TagKey tag = TagKey.create(this.registryKey, (ResourceLocation)id);
        this.initializeTag(tag);
        return tag;
    }

    protected void initializeTag(TagKey<T> tag) {
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
        }
    }

    @Override
    public abstract P createBootstrapContext(boolean var1);

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (TagKey<T> entry : this.tags) {
            b.append("  - ").append(entry).append(" \n");
        }
        return "TagRegistry{registryKey=" + String.valueOf(this.registryKey) + ", directory='" + this.directory + "', tagElements=\n" + b.toString() + "}";
    }

    @Override
    public ResourceKey<? extends Registry<T>> registryKey() {
        return this.registryKey;
    }

    @Override
    public Event<OnBoostrapTags<T, P>> bootstrapEvent() {
        return this.BOOTSTRAP_EVENT;
    }

    P emitLoadEvent(boolean initAll) {
        Object ctx = this.createBootstrapContext(initAll);
        if (!ModCore.isDatagen()) {
            this.BOOTSTRAP_EVENT.emit(c -> c.bootstrap(ctx));
        }
        return ctx;
    }

    public static abstract class WithRegistry<T, P extends TagBootstrapContext<T>>
    extends TagRegistryImpl<T, P> {
        private final DefaultedRegistry<T> registry;

        public WithRegistry(DefaultedRegistry<T> registry) {
            super(registry.key(), Registries.tagsDirPath((ResourceKey)registry.key()), element -> {
                ResourceLocation id = registry.getKey(element);
                if (id != registry.getDefaultKey()) {
                    return id;
                }
                return null;
            });
            this.registry = registry;
        }

        @Override
        public TagKey<T> makeTag(ResourceLocation id) {
            TagKey tag = this.registry.getTagNames().filter(tagKey -> tagKey.location().equals((Object)id)).findAny().orElse(TagKey.create((ResourceKey)this.registry.key(), (ResourceLocation)id));
            this.initializeTag(tag);
            return tag;
        }
    }
}

