/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.tag.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import org.betterx.wover.entrypoint.LibWoverTag;
import org.betterx.wover.state.api.WorldState;
import org.betterx.wover.tag.api.TagRegistry;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.betterx.wover.tag.impl.BiomeTagRegistryImpl;
import org.betterx.wover.tag.impl.ItemTagRegistryImpl;
import org.betterx.wover.tag.impl.TagBootstrapContextImpl;
import org.betterx.wover.tag.impl.TagRegistryImpl;
import org.betterx.wover.tag.impl.TagRegistrySimple;
import org.jetbrains.annotations.ApiStatus;

public class TagManagerImpl {
    private static final Map<String, TagRegistryImpl<?, ?>> TYPES = Maps.newHashMap();
    public static TagRegistryImpl<Block, TagBootstrapContext<Block>> BLOCKS = TagManagerImpl.registerType(BuiltInRegistries.BLOCK);
    public static TagRegistryImpl<Item, ItemTagBootstrapContext> ITEMS = TagManagerImpl.registerItem();
    public static TagRegistryImpl<Enchantment, TagBootstrapContext<Enchantment>> ENCHANTMENTS = TagManagerImpl.registerType(Registries.ENCHANTMENT);
    public static TagRegistryImpl<EntityType<?>, TagBootstrapContext<EntityType<?>>> ENTITY_TYPES = TagManagerImpl.registerType(Registries.ENTITY_TYPE);
    public static BiomeTagRegistryImpl BIOMES = TagManagerImpl.registerBiome();
    private static final ResourceLocation NO_TAG = LibWoverTag.C.mk("no_tag");

    public static <T, P extends TagBootstrapContext<T>> TagRegistryImpl<T, P> registerType(DefaultedRegistry<T> registry) {
        TagRegistrySimple type = new TagRegistrySimple(registry);
        return TYPES.computeIfAbsent(type.directory, dir -> type);
    }

    public static <T, P extends TagBootstrapContext<T>> TagRegistryImpl<T, P> registerType(Registry<T> registry, String directory) {
        return TagManagerImpl.registerType(registry.key(), directory, o -> registry.getKey(o));
    }

    public static <T, P extends TagBootstrapContext<T>> TagRegistryImpl<T, P> registerType(ResourceKey<? extends Registry<T>> registry, String directory, TagRegistry.LocationProvider<T> locationProvider) {
        return TYPES.computeIfAbsent(directory, dir -> new TagRegistryImpl<T, TagBootstrapContext<T>>(registry, (String)dir, locationProvider){

            @Override
            public TagBootstrapContext<T> createBootstrapContext(boolean initAll) {
                return TagBootstrapContextImpl.create(this, initAll);
            }
        });
    }

    public static <T, P extends TagBootstrapContext<T>> TagRegistryImpl<T, P> registerType(ResourceKey<? extends Registry<T>> registryKey) {
        return TagManagerImpl.registerType(registryKey, Registries.tagsDirPath(registryKey), preset -> WorldState.registryAccess() != null ? WorldState.registryAccess().registryOrThrow(registryKey).getKey(preset) : null);
    }

    public static TagRegistryImpl<Item, ItemTagBootstrapContext> registerItem() {
        ItemTagRegistryImpl type = new ItemTagRegistryImpl();
        return TYPES.computeIfAbsent(type.directory, dir -> type);
    }

    static BiomeTagRegistryImpl registerBiome() {
        return (BiomeTagRegistryImpl)TYPES.computeIfAbsent("tags/worldgen/biome", dir -> new BiomeTagRegistryImpl((String)dir, b -> WorldState.getBiomeID((Biome)b)));
    }

    @ApiStatus.Internal
    public static Map<ResourceLocation, List<TagLoader.EntryWithSource>> didLoadTagMap(String directory, Map<ResourceLocation, List<TagLoader.EntryWithSource>> tagsMap) {
        TagRegistryImpl<?, ?> type = TYPES.get(directory);
        if (type != null) {
            Object provider = type.emitLoadEvent(false);
            provider.forEach((tag, entries) -> {
                List builder = tagsMap.computeIfAbsent(tag.location(), key -> Lists.newArrayList());
                entries.forEach(wrapper -> builder.add(new TagLoader.EntryWithSource(wrapper.createTagEntry(), LibWoverTag.C.namespace)));
            });
        }
        return tagsMap;
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, TagKey<T>> streamCodec(final ResourceKey<Registry<T>> registry) {
        return new StreamCodec<RegistryFriendlyByteBuf, TagKey<T>>(){

            public TagKey<T> decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
                ResourceLocation location = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)registryFriendlyByteBuf);
                return TagKey.create((ResourceKey)registry, (ResourceLocation)(location.equals((Object)NO_TAG) ? null : location));
            }

            public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, TagKey<T> tag) {
                ResourceLocation.STREAM_CODEC.encode((Object)registryFriendlyByteBuf, (Object)(tag == null ? NO_TAG : tag.location()));
            }
        };
    }
}

