/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.tag.impl;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.betterx.wover.entrypoint.LibWoverTag;
import org.betterx.wover.tag.api.TagRegistry;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagElementWrapper;
import org.betterx.wover.tag.impl.TagElementWrapperImpl;
import org.betterx.wover.tag.impl.TagRegistryImpl;
import org.betterx.wover.tag.impl.TagSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagBootstrapContextImpl<T, P extends TagBootstrapContext<T>>
implements TagBootstrapContext<T> {
    private final Map<TagKey<T>, TagSet<T>> tags = new ConcurrentHashMap<TagKey<T>, TagSet<T>>();
    @Nullable
    private final TagRegistryImpl<T, P> tagRegistry;
    protected static final ConcurrentHashMap<TagRegistry, TagBootstrapContextImpl> CACHE = new ConcurrentHashMap();

    protected TagBootstrapContextImpl(@Nullable TagRegistryImpl<T, P> tagRegistry) {
        this.tagRegistry = tagRegistry;
    }

    private void clearAll() {
        if (this.tagRegistry == null) {
            return;
        }
        for (TagKey tag : this.tagRegistry.tags) {
            this.initializeTag(tag);
        }
    }

    public static void invalidateCaches() {
        LibWoverTag.C.log.debug("Invalidating TagBootstrapContext Caches");
        CACHE.clear();
    }

    protected static <T, P extends TagBootstrapContext<T>, R extends TagRegistryImpl<T, P>> TagBootstrapContextImpl<T, P> create(@NotNull R tagRegistry, boolean initAll, Function<R, TagBootstrapContextImpl<T, P>> factory) {
        TagBootstrapContextImpl registry = CACHE.computeIfAbsent(tagRegistry, r -> (TagBootstrapContextImpl)factory.apply(tagRegistry));
        if (initAll) {
            registry.clearAll();
        }
        return registry;
    }

    static <T, P extends TagBootstrapContext<T>> TagBootstrapContextImpl<T, P> create(@NotNull TagRegistryImpl<T, P> tagRegistry, boolean initAll) {
        return TagBootstrapContextImpl.create(tagRegistry, initAll, TagBootstrapContextImpl::new);
    }

    protected void initializeTag(TagKey<T> tag) {
        this.getSetForTag(tag);
    }

    public TagSet<T> getSetForTag(TagKey<T> tag) {
        if (tag == null) {
            LibWoverTag.C.log.verboseWarning("Tag should not be null!");
            return new TagSet();
        }
        return this.tags.computeIfAbsent(tag, k -> new TagSet());
    }

    @Override
    public void add(TagKey<T> tagID, T ... elements) {
        this.add(tagID, false, elements);
    }

    @Override
    public void addOptional(TagKey<T> tagID, T ... elements) {
        this.add(tagID, true, elements);
    }

    protected void add(TagKey<T> tagID, boolean optional, T ... elements) {
        TagSet set = this.getSetForTag(tagID);
        for (T element : elements) {
            ResourceLocation id = this.tagRegistry.locationProvider.get(element);
            if (id == null) continue;
            TagElementWrapperImpl wrapper = new TagElementWrapperImpl(id, false, !optional);
            set.add(wrapper);
        }
    }

    @Override
    public void asPlaceholder(TagKey<T> tagID) {
        this.getSetForTag(tagID);
    }

    @Override
    public void add(T element, TagKey<T> ... tags) {
        for (TagKey<T> tagID : tags) {
            this.add(tagID, false, element);
        }
    }

    @Override
    public void addOptional(T element, TagKey<T> ... tags) {
        for (TagKey<T> tagID : tags) {
            this.add(tagID, true, element);
        }
    }

    @Override
    public void add(TagKey<T> tagID, TagKey<T> ... tags) {
        this.add(tagID, false, tags);
    }

    @Override
    public void addOptional(TagKey<T> tagID, TagKey<T> ... tags) {
        this.add(tagID, true, tags);
    }

    protected void add(TagKey<T> tagID, boolean optional, TagKey<T> ... tagElements) {
        TagSet set = this.getSetForTag(tagID);
        for (TagKey<T> element : tagElements) {
            ResourceLocation id = element.location();
            if (id == null) continue;
            TagElementWrapperImpl wrapper = new TagElementWrapperImpl(id, true, !optional);
            set.add(wrapper);
        }
    }

    @Override
    public void add(TagKey<T> tagID, ResourceKey<T> ... elements) {
        this.add(tagID, false, elements);
    }

    @Override
    public void addOptional(TagKey<T> tagID, ResourceKey<T> ... elements) {
        this.add(tagID, true, elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(TagKey<T> tagID, boolean optional, ResourceKey<T> ... elements) {
        TagBootstrapContextImpl tagBootstrapContextImpl = this;
        synchronized (tagBootstrapContextImpl) {
            TagSet set = this.getSetForTag(tagID);
            for (ResourceKey<T> element : elements) {
                ResourceLocation id = element.location();
                if (id == null) continue;
                TagElementWrapperImpl wrapper = new TagElementWrapperImpl(id, false, !optional);
                set.add(wrapper);
            }
        }
    }

    public boolean contains(TagKey<T> tagID, T element) {
        TagSet<T> set = this.getSetForTag(tagID);
        ResourceLocation id = this.tagRegistry.locationProvider.get(element);
        if (id != null) {
            for (TagElementWrapper tagElementWrapper : set) {
                if (tagElementWrapper.tag() || !id.equals((Object)tagElementWrapper.id())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void forEach(BiConsumer<TagKey<T>, List<TagElementWrapper<T>>> consumer) {
        for (Map.Entry<TagKey<T>, TagSet<T>> entry : this.tags.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue().stream().sorted(Comparator.comparing(TagElementWrapper::id)).toList());
        }
    }

    @Override
    public TagRegistry<T, P> registry() {
        return this.tagRegistry;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (Map.Entry<TagKey<T>, TagSet<T>> entry : this.tags.entrySet()) {
            b.append("  - ").append(entry.getKey()).append(": \n");
            for (TagElementWrapper tagElementWrapper : entry.getValue()) {
                b.append("    - ").append(tagElementWrapper).append("\n");
            }
        }
        return "TagElementProviderImpl{tagRegistry=" + String.valueOf(this.tagRegistry) + ", tags=\n" + b.toString() + "}";
    }
}

