/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.datagen.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.WoverDataProvider;
import org.betterx.wover.entrypoint.LibWoverTag;
import org.betterx.wover.tag.api.TagManager;
import org.betterx.wover.tag.api.TagRegistry;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagElementWrapper;
import org.betterx.wover.tag.impl.TagManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WoverTagProvider<T, P extends TagBootstrapContext<T>>
implements WoverDataProvider<FabricTagProvider<T>> {
    @Nullable
    protected List<String> modIDs;
    public final ModCore modCore;
    public final TagRegistry<T, P> tagRegistry;
    private Set<TagKey<T>> forceWrite;

    @NotNull
    private static List<String> defaultModIDList(ModCore modCore) {
        return List.of(modCore.namespace, modCore.modId);
    }

    public WoverTagProvider(ModCore modCore, TagRegistry<T, P> tagRegistry) {
        this(modCore, tagRegistry, WoverTagProvider.defaultModIDList(modCore), Set.of());
    }

    public WoverTagProvider(ModCore modCore, TagRegistry<T, P> tagRegistry, Set<TagKey<T>> forceWriteKeys) {
        this(modCore, tagRegistry, WoverTagProvider.defaultModIDList(modCore), forceWriteKeys);
    }

    public WoverTagProvider(ModCore modCore, TagRegistry<T, P> tagRegistry, @Nullable List<String> modIDs) {
        this(modCore, tagRegistry, modIDs, Set.of());
    }

    public WoverTagProvider(ModCore modCore, TagRegistry<T, P> tagRegistry, @Nullable List<String> modIDs, Set<TagKey<T>> forceWriteKeys) {
        this.modCore = modCore;
        this.tagRegistry = tagRegistry;
        this.modIDs = modIDs;
        this.forceWrite = forceWriteKeys;
    }

    public void mergeAllowedAndForced(@Nullable WoverTagProvider<T, ?> provider) {
        if (provider != null) {
            HashSet<TagKey<T>> c = new HashSet<TagKey<T>>(this.forceWrite);
            c.addAll(provider.forceWrite);
            this.forceWrite = Collections.unmodifiableSet(c);
            if (provider.modIDs != null) {
                if (this.modIDs == null) {
                    this.modIDs = Collections.unmodifiableList(new LinkedList<String>(provider.modIDs));
                } else {
                    LinkedList<String> l = new LinkedList<String>(provider.modIDs);
                    l.addAll(this.modIDs);
                    this.modIDs = Collections.unmodifiableList(l);
                }
            }
        }
    }

    protected boolean shouldAdd(ResourceLocation loc) {
        return this.modIDs == null || this.modIDs.contains(loc.getNamespace());
    }

    public abstract void prepareTags(P var1);

    protected boolean initAll() {
        return false;
    }

    protected String getTitle() {
        return this.modCore.namespace + "/" + this.getClass().getSimpleName();
    }

    protected boolean replaceOriginalTags() {
        return false;
    }

    public FabricTagProvider<T> getProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        return new FabricTagProvider<T>(output, this.tagRegistry.registryKey(), registriesFuture){

            public String getName() {
                return WoverTagProvider.this.getTitle() + " (" + super.getName() + ")";
            }

            protected final void addTags(HolderLookup.Provider arg) {
                Object provider = WoverTagProvider.this.tagRegistry.createBootstrapContext(WoverTagProvider.this.initAll());
                WoverTagProvider.this.forceWrite.forEach(arg_0 -> provider.asPlaceholder(arg_0));
                WoverTagProvider.this.prepareTags(provider);
                LibWoverTag.C.LOG.debug("    ****> Writing tags for {}", new Object[]{WoverTagProvider.this.modIDs});
                provider.forEach((tag, allElements) -> {
                    List<TagElementWrapper> elements;
                    boolean force = WoverTagProvider.this.forceWrite.contains(tag);
                    List<TagElementWrapper> list = elements = WoverTagProvider.this.shouldAdd(tag.location()) ? allElements : allElements.stream().filter(element -> WoverTagProvider.this.shouldAdd(element.id())).toList();
                    if (!force && elements.isEmpty()) {
                        return;
                    }
                    FabricTagProvider.FabricTagBuilder builder = this.getOrCreateTagBuilder((TagKey)tag).setReplace(WoverTagProvider.this.replaceOriginalTags());
                    for (TagElementWrapper element2 : elements) {
                        if (element2.tag()) {
                            if (element2.required()) {
                                builder.forceAddTag(TagKey.create((ResourceKey)this.registryKey, (ResourceLocation)element2.id()));
                                continue;
                            }
                            builder.addOptionalTag(element2.id());
                            continue;
                        }
                        if (element2.required()) {
                            builder.add(element2.id());
                            continue;
                        }
                        builder.addOptional(element2.id());
                    }
                });
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for " + String.valueOf(this.modCore) + " (" + String.valueOf(this.modIDs) + ")";
    }

    public static abstract class ForEntityTypes
    extends WoverTagProvider<EntityType<?>, TagBootstrapContext<EntityType<?>>> {
        public ForEntityTypes(ModCore modCore) {
            super(modCore, TagManager.ENTITY_TYPES);
        }

        public ForEntityTypes(ModCore modCore, @Nullable List<String> modIDs) {
            super(modCore, TagManager.ENTITY_TYPES, modIDs);
        }

        public ForEntityTypes(ModCore modCore, Set<TagKey<EntityType<?>>> forceWriteKeys) {
            super(modCore, TagManager.ENTITY_TYPES, forceWriteKeys);
        }

        public ForEntityTypes(ModCore modCore, @Nullable List<String> modIDs, Set<TagKey<EntityType<?>>> forceWriteKeys) {
            super(modCore, TagManager.ENTITY_TYPES, modIDs, forceWriteKeys);
        }
    }

    public static abstract class ForEnchantments
    extends WoverTagProvider<Enchantment, TagBootstrapContext<Enchantment>> {
        public ForEnchantments(ModCore modCore) {
            super(modCore, TagManager.ENCHANTMENTS);
        }

        public ForEnchantments(ModCore modCore, @Nullable List<String> modIDs) {
            super(modCore, TagManager.ENCHANTMENTS, modIDs);
        }

        public ForEnchantments(ModCore modCore, Set<TagKey<Enchantment>> forceWriteKeys) {
            super(modCore, TagManager.ENCHANTMENTS, forceWriteKeys);
        }

        public ForEnchantments(ModCore modCore, @Nullable List<String> modIDs, Set<TagKey<Enchantment>> forceWriteKeys) {
            super(modCore, TagManager.ENCHANTMENTS, modIDs, forceWriteKeys);
        }
    }

    public static abstract class ForBiomes
    extends WoverTagProvider<Biome, TagBootstrapContext<Biome>> {
        public ForBiomes(ModCore modCore) {
            super(modCore, TagManagerImpl.BIOMES);
        }

        public ForBiomes(ModCore modCore, @Nullable List<String> modIDs) {
            super(modCore, TagManagerImpl.BIOMES, modIDs);
        }

        public ForBiomes(ModCore modCore, Set<TagKey<Biome>> forceWriteKeys) {
            super(modCore, TagManagerImpl.BIOMES, forceWriteKeys);
        }

        public ForBiomes(ModCore modCore, @Nullable List<String> modIDs, Set<TagKey<Biome>> forceWriteKeys) {
            super(modCore, TagManagerImpl.BIOMES, modIDs, forceWriteKeys);
        }
    }

    public static abstract class ForItems
    extends WoverTagProvider<Item, ItemTagBootstrapContext> {
        public ForItems(ModCore modCore) {
            super(modCore, TagManagerImpl.ITEMS);
        }

        public ForItems(ModCore modCore, @Nullable List<String> modIDs) {
            super(modCore, TagManagerImpl.ITEMS, modIDs);
        }

        public ForItems(ModCore modCore, Set<TagKey<Item>> forceWriteKeys) {
            super(modCore, TagManagerImpl.ITEMS, forceWriteKeys);
        }

        public ForItems(ModCore modCore, @Nullable List<String> modIDs, Set<TagKey<Item>> forceWriteKeys) {
            super(modCore, TagManagerImpl.ITEMS, modIDs, forceWriteKeys);
        }
    }

    public static abstract class ForBlocks
    extends WoverTagProvider<Block, TagBootstrapContext<Block>> {
        public ForBlocks(ModCore modCore) {
            super(modCore, TagManagerImpl.BLOCKS);
        }

        public ForBlocks(ModCore modCore, @Nullable List<String> modIDs) {
            super(modCore, TagManagerImpl.BLOCKS, modIDs);
        }

        public ForBlocks(ModCore modCore, Set<TagKey<Block>> forceWriteKeys) {
            super(modCore, TagManagerImpl.BLOCKS, forceWriteKeys);
        }

        public ForBlocks(ModCore modCore, @Nullable List<String> modIDs, Set<TagKey<Block>> forceWriteKeys) {
            super(modCore, TagManagerImpl.BLOCKS, modIDs, forceWriteKeys);
        }
    }
}

