/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.surface.impl.numeric;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.util.RandomSource;
import org.betterx.wover.math.api.random.RandomHelper;
import org.betterx.wover.surface.api.Conditions;
import org.betterx.wover.surface.api.conditions.SurfaceRulesContext;
import org.betterx.wover.surface.api.noise.NumericProvider;

public class NetherNoiseCondition
implements NumericProvider {
    public static final NumericProvider INSTANCE = new NetherNoiseCondition();
    public static final MapCodec<NetherNoiseCondition> CODEC = Codec.BYTE.fieldOf("nether_noise").xmap(obj -> (NetherNoiseCondition)INSTANCE, obj -> (byte)0);

    @Override
    public MapCodec<? extends NumericProvider> pcodec() {
        return CODEC;
    }

    @Override
    public int getNumber(SurfaceRulesContext context) {
        int x = context.getBlockX();
        int y = context.getBlockY();
        int z = context.getBlockZ();
        double value = Conditions.NETHER_VOLUME_NOISE.getNoiseContext().getNoise().eval((double)x * Conditions.NETHER_VOLUME_NOISE.getScaleX(), (double)y * Conditions.NETHER_VOLUME_NOISE.getScaleY(), (double)z * Conditions.NETHER_VOLUME_NOISE.getScaleZ());
        int offset = Conditions.NETHER_VOLUME_NOISE.getNoiseContext().getRandom().nextInt(20) == 0 ? 3 : 0;
        float cmp = RandomHelper.inRange((RandomSource)Conditions.NETHER_VOLUME_NOISE.getNoiseContext().getRandom(), (float)0.4f, (float)0.5f);
        if (value > (double)cmp || value < (double)(-cmp)) {
            return 2 + offset;
        }
        if (value > (double)Conditions.NETHER_VOLUME_NOISE.getRoughness().sample(Conditions.NETHER_VOLUME_NOISE.getNoiseContext().getRandom())) {
            return 0 + offset;
        }
        return 1 + offset;
    }
}

