/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.surface.impl.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.betterx.wover.surface.api.noise.NoiseParameterManager;
import org.betterx.wover.surface.mixin.SurfaceRulesContextAccessor;

public class RoughNoiseConditionImpl
implements SurfaceRules.ConditionSource {
    public static final MapCodec<RoughNoiseConditionImpl> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.NOISE).fieldOf("noise").forGetter(o -> o.noise), (App)Codec.DOUBLE.fieldOf("min_threshold").forGetter(o -> o.minThreshold), (App)Codec.DOUBLE.fieldOf("max_threshold").orElse((Object)Double.MAX_VALUE).forGetter(o -> o.maxThreshold), (App)FloatProvider.CODEC.fieldOf("roughness").forGetter(o -> o.roughness)).apply((Applicative)instance, (noise1, minThreshold1, maxThreshold1, roughness1) -> new RoughNoiseConditionImpl((ResourceKey<NormalNoise.NoiseParameters>)noise1, (FloatProvider)roughness1, (double)minThreshold1, (double)maxThreshold1)));
    public static final KeyDispatchDataCodec<RoughNoiseConditionImpl> KEY_CODEC = KeyDispatchDataCodec.of(CODEC);
    private final ResourceKey<NormalNoise.NoiseParameters> noise;
    private final double minThreshold;
    private final double maxThreshold;
    private final FloatProvider roughness;

    public RoughNoiseConditionImpl(ResourceKey<NormalNoise.NoiseParameters> noise, FloatProvider roughness, double minThreshold, double maxThreshold) {
        this.noise = noise;
        this.minThreshold = minThreshold;
        this.maxThreshold = maxThreshold;
        this.roughness = roughness;
    }

    public RoughNoiseConditionImpl(ResourceKey<NormalNoise.NoiseParameters> noise, double minThreshold, double maxThreshold) {
        this(noise, (FloatProvider)UniformFloat.of((float)-0.1f, (float)0.4f), minThreshold, maxThreshold);
    }

    public KeyDispatchDataCodec<? extends SurfaceRules.ConditionSource> codec() {
        return KEY_CODEC;
    }

    public SurfaceRules.Condition apply(final SurfaceRules.Context context2) {
        final SurfaceRulesContextAccessor ctx = (SurfaceRulesContextAccessor)SurfaceRulesContextAccessor.class.cast(context2);
        final NormalNoise normalNoise = ctx.getRandomState().getOrCreateNoise(this.noise);
        final RandomSource roughnessSource = ctx.getRandomState().getOrCreateRandomFactory(NoiseParameterManager.ROUGHNESS_NOISE.location()).fromHashOf(NoiseParameterManager.ROUGHNESS_NOISE.location());
        class NoiseThresholdCondition
        extends SurfaceRules.LazyCondition {
            NoiseThresholdCondition() {
                super(context);
            }

            protected long getContextLastUpdate() {
                SurfaceRulesContextAccessor ctx2 = (SurfaceRulesContextAccessor)SurfaceRulesContextAccessor.class.cast(this.context);
                return ctx2.getLastUpdateY() + ctx2.getLastUpdateXZ();
            }

            protected boolean compute() {
                double d = normalNoise.getValue((double)ctx.getBlockX(), (double)ctx.getBlockY(), (double)ctx.getBlockZ()) + (double)RoughNoiseConditionImpl.this.roughness.sample(roughnessSource);
                return d >= RoughNoiseConditionImpl.this.minThreshold && d <= RoughNoiseConditionImpl.this.maxThreshold;
            }
        }
        return new NoiseThresholdCondition();
    }
}

