/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.surface.impl.conditions;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.betterx.wover.core.api.registry.BuiltInRegistryManager;
import org.betterx.wover.entrypoint.LibWoverSurface;
import org.betterx.wover.legacy.api.LegacyHelper;
import org.betterx.wover.surface.api.conditions.ConditionManager;
import org.betterx.wover.surface.impl.conditions.RoughNoiseConditionImpl;
import org.betterx.wover.surface.impl.conditions.ThresholdConditionImpl;
import org.betterx.wover.surface.impl.conditions.VolumeThresholdConditionImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class MaterialConditionRegistryImpl {
    public static final ResourceKey<MapCodec<? extends SurfaceRules.ConditionSource>> THRESHOLD_CONDITION = ConditionManager.createKey(LibWoverSurface.C.id("threshold_condition"));
    public static final ResourceKey<MapCodec<? extends SurfaceRules.ConditionSource>> VOLUME_THRESHOLD_CONDITION = ConditionManager.createKey(LibWoverSurface.C.id("volume_threshold_condition"));
    public static final ResourceKey<MapCodec<? extends SurfaceRules.ConditionSource>> ROUGH_NOISE_CONDITION = ConditionManager.createKey(LibWoverSurface.C.id("rough_noise_condition"));

    public static ResourceKey<MapCodec<? extends SurfaceRules.ConditionSource>> register(ResourceKey<MapCodec<? extends SurfaceRules.ConditionSource>> key, MapCodec<? extends SurfaceRules.ConditionSource> codec, boolean withBCLibLegacy) {
        BuiltInRegistryManager.register((Registry)BuiltInRegistries.MATERIAL_CONDITION, key, codec);
        if (withBCLibLegacy && LegacyHelper.isLegacyEnabled()) {
            BuiltInRegistryManager.register((Registry)BuiltInRegistries.MATERIAL_CONDITION, (ResourceLocation)LegacyHelper.BCLIB_CORE.convertNamespace(key.location()), (Object)LegacyHelper.wrap(codec));
        }
        return key;
    }

    @NotNull
    public static ResourceKey<MapCodec<? extends SurfaceRules.ConditionSource>> createKey(ResourceLocation location) {
        return ResourceKey.create((ResourceKey)BuiltInRegistries.MATERIAL_CONDITION.key(), (ResourceLocation)location);
    }

    @ApiStatus.Internal
    public static void bootstrap() {
        MaterialConditionRegistryImpl.register(THRESHOLD_CONDITION, ThresholdConditionImpl.CODEC, true);
        MaterialConditionRegistryImpl.register(VOLUME_THRESHOLD_CONDITION, VolumeThresholdConditionImpl.CODEC, true);
        MaterialConditionRegistryImpl.register(ROUGH_NOISE_CONDITION, RoughNoiseConditionImpl.CODEC, true);
    }
}

