/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.surface.impl;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.WorldData;
import org.betterx.wover.common.surface.api.InjectableSurfaceRules;
import org.betterx.wover.common.surface.api.SurfaceRuleProvider;
import org.betterx.wover.entrypoint.LibWoverSurface;
import org.betterx.wover.state.api.WorldState;
import org.betterx.wover.surface.api.SurfaceRuleRegistry;
import org.jetbrains.annotations.ApiStatus;

public class SurfaceRuleUtil {
    private static List<SurfaceRules.RuleSource> getRulesForBiome(ResourceKey<Biome> biomeKey) {
        Registry registry = null;
        if (WorldState.registryAccess() != null) {
            registry = WorldState.registryAccess().registry(SurfaceRuleRegistry.SURFACE_RULES_REGISTRY).orElse(null);
        }
        if (registry == null) {
            LibWoverSurface.C.LOG.warn("No Surface Rule Registry found. Skipping Surface Rule Injection for Biome {}", new Object[]{biomeKey.location()});
            return List.of();
        }
        List<SurfaceRules.RuleSource> list = registry.stream().filter(a -> a != null && a.biomeID != null && a.biomeID.equals((Object)biomeKey.location())).sorted((a, b) -> b.priority - a.priority).map(a -> a.ruleSource).toList();
        if (list.size() == 0) {
            return List.of();
        }
        return List.of(SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)new SurfaceRules.SequenceRuleSource(list)));
    }

    private static List<SurfaceRules.RuleSource> getRulesForBiomes(List<Optional<ResourceKey<Biome>>> biomes) {
        List<ResourceKey> biomeIDs = biomes.stream().filter(Optional::isPresent).map(Optional::orElseThrow).toList();
        return biomeIDs.stream().map(SurfaceRuleUtil::getRulesForBiome).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedList::new));
    }

    private static SurfaceRules.RuleSource mergeSurfaceRules(ResourceKey<LevelStem> dimensionKey, SurfaceRules.RuleSource org, BiomeSource source, List<SurfaceRules.RuleSource> additionalRules) {
        if (additionalRules == null || additionalRules.isEmpty()) {
            return null;
        }
        Stopwatch sw = Stopwatch.createStarted();
        int count = additionalRules.size();
        if (org instanceof SurfaceRules.SequenceRuleSource) {
            SurfaceRules.SequenceRuleSource sequenceRule = (SurfaceRules.SequenceRuleSource)org;
            List existingSequence = sequenceRule.sequence();
            if ((additionalRules = additionalRules.stream().filter(r -> !existingSequence.contains(r)).collect(Collectors.toList())).isEmpty()) {
                return null;
            }
            if (dimensionKey.equals((Object)LevelStem.NETHER)) {
                ArrayList<Object> combined = new ArrayList<Object>(existingSequence.size() + additionalRules.size());
                for (SurfaceRules.RuleSource rule : existingSequence) {
                    SurfaceRules.TestRuleSource testRule;
                    if (rule instanceof SurfaceRules.TestRuleSource && (testRule = (SurfaceRules.TestRuleSource)rule).ifTrue() instanceof SurfaceRules.BiomeConditionSource) {
                        combined.addAll(additionalRules);
                    }
                    combined.add(rule);
                }
                additionalRules = combined;
            } else {
                additionalRules.addAll(existingSequence);
            }
        } else if (!additionalRules.contains(org)) {
            additionalRules.add(org);
        }
        LibWoverSurface.C.LOG.verbose("Merged {} additional Surface Rules for Dimension {} => {} ({}) using {}", new Object[]{count, dimensionKey.location(), additionalRules.size(), sw.stop(), source});
        return new SurfaceRules.SequenceRuleSource(additionalRules);
    }

    @ApiStatus.Internal
    public static void injectNoiseBasedSurfaceRules(ResourceKey<LevelStem> dimensionKey, Holder<NoiseGeneratorSettings> noiseSettings, BiomeSource loadedBiomeSource) {
        Object o = noiseSettings.value();
        if (o instanceof SurfaceRuleProvider) {
            SurfaceRuleProvider srp = (SurfaceRuleProvider)o;
            SurfaceRules.RuleSource originalRules = srp.wover_getOriginalSurfaceRules();
            srp.wover_overwriteSurfaceRules(SurfaceRuleUtil.mergeSurfaceRules(dimensionKey, originalRules, loadedBiomeSource, SurfaceRuleUtil.getRulesForBiomes(loadedBiomeSource.possibleBiomes().stream().map(Holder::unwrapKey).toList())));
        }
    }

    static void injectSurfaceRulesToAllDimensions(LevelStorageSource.LevelStorageAccess ignoredStorageAccess, PackRepository ignoredPackRepository, LayeredRegistryAccess<RegistryLayer> registries, WorldData ignoredWorldData) {
        Registry dimensionRegistry = registries.compositeAccess().registryOrThrow(Registries.LEVEL_STEM);
        for (Map.Entry entry : dimensionRegistry.entrySet()) {
            ResourceKey dimensionKey = (ResourceKey)entry.getKey();
            LevelStem stem = (LevelStem)entry.getValue();
            ChunkGenerator chunkGenerator = stem.generator();
            if (!(chunkGenerator instanceof InjectableSurfaceRules)) continue;
            InjectableSurfaceRules generator = (InjectableSurfaceRules)chunkGenerator;
            generator.wover_injectSurfaceRules(dimensionRegistry, dimensionKey);
        }
    }
}

