/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.surface.api;

import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.betterx.wover.surface.api.conditions.NoiseCondition;
import org.betterx.wover.surface.api.conditions.VolumeThresholdCondition;
import org.betterx.wover.surface.impl.conditions.RoughNoiseConditionImpl;
import org.betterx.wover.surface.impl.conditions.ThresholdConditionImpl;
import org.betterx.wover.surface.impl.conditions.VolumeThresholdConditionImpl;

public class Conditions {
    public static final NoiseCondition DOUBLE_BLOCK_SURFACE_NOISE = Conditions.threshold(4141L, 0.0, (FloatProvider)UniformFloat.of((float)-0.4f, (float)0.4f), 0.1, 0.1);
    public static final NoiseCondition FORREST_FLOOR_SURFACE_NOISE_A = Conditions.threshold(614L, 0.0, (FloatProvider)UniformFloat.of((float)-0.2f, (float)0.0f), 0.1, 0.1);
    public static final NoiseCondition FORREST_FLOOR_SURFACE_NOISE_B = Conditions.threshold(614L, 0.0, (FloatProvider)UniformFloat.of((float)-0.7f, (float)-0.5f), 0.1, 0.1);
    public static final NoiseCondition NETHER_SURFACE_NOISE = Conditions.threshold(245L, 0.0, (FloatProvider)UniformFloat.of((float)-0.7f, (float)-0.5f), 0.05, 0.05);
    public static final NoiseCondition NETHER_SURFACE_NOISE_LARGE = Conditions.threshold(523L, 0.0, (FloatProvider)UniformFloat.of((float)-0.4f, (float)-0.3f), 0.5, 0.5);
    public static final VolumeThresholdCondition NETHER_VOLUME_NOISE = Conditions.volumeThreshold(245L, 0.0, (FloatProvider)UniformFloat.of((float)-0.1f, (float)0.2f), 0.1, 0.2, 0.1);
    public static final VolumeThresholdCondition NETHER_VOLUME_NOISE_LARGE = Conditions.volumeThreshold(523L, 0.0, (FloatProvider)UniformFloat.of((float)-0.1f, (float)0.4f), 0.2, 0.2, 0.2);

    public static NoiseCondition threshold(long noiseSeed, double threshold, FloatProvider roughness, double scaleX, double scaleZ) {
        return new ThresholdConditionImpl(noiseSeed, threshold, roughness, scaleX, scaleZ);
    }

    public static VolumeThresholdCondition volumeThreshold(long noiseSeed, double threshold, FloatProvider roughness, double scaleX, double scaleY, double scaleZ) {
        return new VolumeThresholdConditionImpl(noiseSeed, threshold, roughness, scaleX, scaleY, scaleZ);
    }

    public static SurfaceRules.ConditionSource roughNoise(ResourceKey<NormalNoise.NoiseParameters> noise, FloatProvider roughness, double minThreshold, double maxThreshold) {
        return new RoughNoiseConditionImpl(noise, roughness, minThreshold, maxThreshold);
    }

    public static SurfaceRules.ConditionSource roughNoise(ResourceKey<NormalNoise.NoiseParameters> noise, FloatProvider roughness, double minThreshold) {
        return new RoughNoiseConditionImpl(noise, roughness, minThreshold, Double.MAX_VALUE);
    }

    public static SurfaceRules.ConditionSource roughNoise(ResourceKey<NormalNoise.NoiseParameters> noise, double minThreshold) {
        return new RoughNoiseConditionImpl(noise, (FloatProvider)UniformFloat.of((float)-0.2f, (float)0.4f), minThreshold, Double.MAX_VALUE);
    }

    private Conditions() {
    }
}

