/*
 * Decompiled with CFR 0.152.
 */
package minenash.enhanced_attack_indicator;

import com.mojang.logging.LogUtils;
import java.util.List;
import minenash.enhanced_attack_indicator.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import org.slf4j.Logger;

@Mod(value="enhanced_attack_indicator")
public class EnhancedAttackIndicator {
    public static final String MODID = "enhanced_attack_indicator";
    private static final Logger LOGGER = LogUtils.getLogger();

    public EnhancedAttackIndicator(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.SPEC);
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    public static float getProgress(float weaponProgress) {
        ItemStack stack;
        Item item;
        float breakingProgress;
        int sleep;
        LocalPlayer player = Minecraft.getInstance().player;
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        if (Config.weaponCoolDownImportance == Config.WeaponCoolDownImportance.FIRST && weaponProgress < 1.0f) {
            return EnhancedAttackIndicator.weaponCooldown(mainHand.getItem(), weaponProgress);
        }
        if (Config.showSleep && (sleep = player.getSleepTimer()) > 0 && sleep <= 100) {
            return sleep == 100 ? 2.0f : (float)sleep / 100.0f;
        }
        if (Config.showBlockBreaking && (breakingProgress = (float)Minecraft.getInstance().gameMode.getDestroyStage()) > 0.0f) {
            return breakingProgress / 10.0f;
        }
        if (Config.showRangeWeaponDraw) {
            ItemStack stack2 = player.getUseItem();
            item = stack2.getItem();
            if (item == Items.BOW) {
                float progress = BowItem.getPowerForTime((int)(72000 - player.getUseItemRemainingTicks()));
                return progress == 1.0f ? 2.0f : progress;
            }
            if (item == Items.CROSSBOW) {
                float progress = (float)(stack2.getUseDuration((LivingEntity)player) - player.getUseItemRemainingTicks()) / (float)CrossbowItem.getChargeDuration((ItemStack)stack2, (LivingEntity)player);
                return progress >= 1.0f ? 2.0f : progress;
            }
            if (item == Items.TRIDENT) {
                float progress = (float)(stack2.getUseDuration((LivingEntity)player) - player.getUseItemRemainingTicks()) / 10.0f;
                return progress >= 1.0f ? 2.0f : progress;
            }
        }
        if (Config.showFoodAndPotions && ((item = (stack = player.getUseItem()).getItem()).components().has(DataComponents.FOOD) || item == Items.POTION)) {
            float itemCooldown = (float)player.getUseItemRemainingTicks() / (float)stack.getUseDuration((LivingEntity)player);
            return itemCooldown == 0.0f ? 1.0f : itemCooldown;
        }
        if (Config.showItemContainerFullness) {
            ItemStack stack3 = player.getMainHandItem();
            ItemContainerContents container = (ItemContainerContents)stack3.get(DataComponents.CONTAINER);
            if (container != null) {
                List items = container.stream().toList();
                int total = 0;
                int maxTotal = 64 * (27 - items.size());
                for (ItemStack item2 : items) {
                    total += item2.getCount();
                    maxTotal += item2.getMaxStackSize();
                }
                float result = (float)total / (float)maxTotal;
                return result == 1.0f ? 2.0f : result;
            }
            BundleContents bundle = (BundleContents)stack3.get(DataComponents.BUNDLE_CONTENTS);
            if (bundle != null) {
                int total = 0;
                for (ItemStack item3 : bundle.items()) {
                    total += item3.getCount();
                }
                return (float)total / 64.0f;
            }
        }
        if (Config.weaponCoolDownImportance == Config.WeaponCoolDownImportance.MIDDLE && weaponProgress < 1.0f) {
            return EnhancedAttackIndicator.weaponCooldown(mainHand.getItem(), weaponProgress);
        }
        if (Config.showItemCooldowns) {
            float cooldown = player.getCooldowns().getCooldownPercent(offHand.getItem(), 0.0f);
            if (cooldown != 0.0f) {
                return cooldown;
            }
            cooldown = player.getCooldowns().getCooldownPercent(mainHand.getItem(), 0.0f);
            if (cooldown != 0.0f) {
                return cooldown;
            }
        }
        if (Config.showRangeWeaponDraw && (mainHand.getItem() == Items.CROSSBOW && CrossbowItem.isCharged((ItemStack)mainHand) || offHand.getItem() == Items.CROSSBOW && CrossbowItem.isCharged((ItemStack)mainHand))) {
            return 2.0f;
        }
        if (Config.weaponCoolDownImportance == Config.WeaponCoolDownImportance.LAST) {
            return EnhancedAttackIndicator.weaponCooldown(mainHand.getItem(), weaponProgress);
        }
        return 1.0f;
    }

    private static float weaponCooldown(Item item, float weaponProgress) {
        if (Config.disablePickaxesAndShovels && (item.getDescriptionId().contains("pickaxe") || item.getDescriptionId().contains("shovel"))) {
            return 1.0f;
        }
        if (Config.disableAxes && item.getDescriptionId().contains("axe") && !item.getDescriptionId().contains("pickaxe")) {
            return 1.0f;
        }
        return weaponProgress;
    }
}

