/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.item.api.armor;

import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.betterx.wover.core.api.registry.BuiltInRegistryManager;

public class CustomArmorMaterial {
    public static Builder start(class_2960 location) {
        return new Builder(location);
    }

    public static class Builder {
        private final class_2960 location;
        private final EnumMap<class_1738.class_8051, Integer> defense;
        private int enchantmentValue;
        private class_6880<class_3414> equipSound;
        private float toughness;
        private float knockbackResistance;
        private Supplier<class_1856> repairIngredientSupplier;
        List<class_1741.class_9196> layers;

        private Builder(class_2960 location) {
            this.location = location;
            this.defense = new EnumMap(class_1738.class_8051.class);
        }

        public Builder defense(int boots, int leggings, int chestplate, int helmet, int body) {
            this.defense(class_1738.class_8051.field_41937, boots);
            this.defense(class_1738.class_8051.field_41936, leggings);
            this.defense(class_1738.class_8051.field_41935, chestplate);
            this.defense(class_1738.class_8051.field_41934, helmet);
            this.defense(class_1738.class_8051.field_48838, body);
            return this;
        }

        public Builder defense(class_1738.class_8051 type, int defense) {
            this.defense.put(type, defense);
            return this;
        }

        public Builder enchantmentValue(int enchantmentValue) {
            this.enchantmentValue = enchantmentValue;
            return this;
        }

        public Builder equipSound(class_6880<class_3414> equipSound) {
            this.equipSound = equipSound;
            return this;
        }

        public Builder toughness(float toughness) {
            this.toughness = toughness;
            return this;
        }

        public Builder knockbackResistance(float knockbackResistance) {
            this.knockbackResistance = knockbackResistance;
            return this;
        }

        public Builder repairIngredientSupplier(Supplier<class_1856> repairIngredientSupplier) {
            this.repairIngredientSupplier = repairIngredientSupplier;
            return this;
        }

        public Builder layers(List<class_1741.class_9196> layers) {
            this.layers = layers;
            return this;
        }

        protected void validate() throws IllegalStateException {
            if (this.defense.size() != class_1738.class_8051.values().length) {
                throw new IllegalStateException("Defense values must be set for all armor types");
            }
            if (this.enchantmentValue < 0) {
                throw new IllegalStateException("Enchantment value must be non-negative");
            }
            if (this.equipSound == null) {
                throw new IllegalStateException("Equip sound must be set");
            }
            if (this.toughness < 0.0f) {
                throw new IllegalStateException("Toughness must be non-negative");
            }
            if (this.knockbackResistance < 0.0f) {
                throw new IllegalStateException("Knockback resistance must be non-negative");
            }
            if (this.repairIngredientSupplier == null) {
                throw new IllegalStateException("Repair ingredient supplier must be set");
            }
        }

        public class_1741 build() {
            if (this.layers == null) {
                this.layers = List.of(new class_1741.class_9196(this.location));
            }
            this.validate();
            return new class_1741(this.defense, this.enchantmentValue, this.equipSound, this.repairIngredientSupplier, this.layers, this.toughness, this.knockbackResistance);
        }

        public class_6880<class_1741> buildAndRegister() {
            return BuiltInRegistryManager.registerForHolder((class_2378)class_7923.field_48976, (class_2960)this.location, (Object)this.build());
        }
    }
}

