/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.item.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_2315;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2378;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_4174;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_8052;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.item.api.ItemTagProvider;
import org.betterx.wover.item.api.smithing.SmithingTemplates;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;

public class ItemRegistry {
    private static final Map<ModCore, ItemRegistry> REGISTRIES = new HashMap<ModCore, ItemRegistry>();
    public final ModCore C;
    private final Map<class_2960, class_1792> items = new HashMap<class_2960, class_1792>();
    private Map<class_1792, class_6862<class_1792>[]> datagenTags;

    private ItemRegistry(ModCore modeCore) {
        this.C = modeCore;
        if (ModCore.isDatagen()) {
            this.datagenTags = new HashMap<class_1792, class_6862<class_1792>[]>();
        }
    }

    public static Stream<ItemRegistry> streamAll() {
        return REGISTRIES.values().stream();
    }

    public static ItemRegistry forMod(ModCore modCore) {
        return REGISTRIES.computeIfAbsent(modCore, c -> new ItemRegistry(modCore));
    }

    public Stream<class_1792> allItems() {
        return this.items.values().stream();
    }

    public <T extends class_1792> T register(String path, T item, class_6862<class_1792> ... tags) {
        if (item != null && item != class_1802.field_8162) {
            class_2960 id = this.C.mk(path);
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)id, item);
            this.items.put(id, item);
            if (this.datagenTags != null && tags != null && tags.length > 0) {
                this.datagenTags.put(item, tags);
            }
        }
        return item;
    }

    public <T extends class_1792> T registerAsTool(String path, T item, class_6862<class_1792> ... tags) {
        this.register(path, item, tags);
        return item;
    }

    public class_4174.class_4175 foodPropertiesOf(int hunger, float saturation, class_1293 ... effects) {
        class_4174.class_4175 builder = new class_4174.class_4175().method_19238(hunger).method_19237(saturation);
        for (class_1293 effect : effects) {
            builder.method_19239(effect, 1.0f);
        }
        return builder;
    }

    public class_4174.class_4175 drinkPropertiesOf(int hunger, float saturation) {
        return new class_4174.class_4175().method_19238(hunger).method_19237(saturation);
    }

    public <T extends class_1792> T registerFood(String name, Function<class_1792.class_1793, T> factory, int hunger, float saturation, class_1293 ... effects) {
        return this.registerFood(name, factory, this.createDefaultItemSettings(), hunger, saturation, effects);
    }

    public <T extends class_1792> T registerFood(String name, Function<class_1792.class_1793, T> factory, class_1792.class_1793 properties, int hunger, float saturation, class_1293 ... effects) {
        return (T)this.register(name, (class_1792)factory.apply(properties.method_19265(this.foodPropertiesOf(hunger, saturation, effects).method_19242())), new class_6862[0]);
    }

    public <T extends class_1792> T registerDrink(String name, Function<class_1792.class_1793, T> factory, int hunger, float saturation, class_1293 ... effects) {
        return this.registerDrink(name, factory, this.createDefaultItemSettings(), hunger, saturation, effects);
    }

    public <T extends class_1792> T registerDrink(String name, Function<class_1792.class_1793, T> factory, class_1792.class_1793 properties, int hunger, float saturation, class_1293 ... effects) {
        return (T)this.register(name, (class_1792)factory.apply(properties.method_19265(this.drinkPropertiesOf(hunger, saturation).method_19242())), new class_6862[0]);
    }

    public <T extends class_1826> T registerEgg(String path, T item, class_6862<class_1792> ... tags) {
        class_2347 behavior = new class_2347(this){

            public class_1799 method_10135(class_2342 pointer, class_1799 stack) {
                class_2350 direction = (class_2350)pointer.comp_1969().method_11654((class_2769)class_2315.field_10918);
                class_1299 entityType = ((class_1826)stack.method_7909()).method_8015(stack);
                entityType.method_5894(pointer.comp_1967(), stack, null, pointer.comp_1968().method_10093(direction), class_3730.field_16470, direction != class_2350.field_11036, false);
                stack.method_7934(1);
                return stack;
            }
        };
        class_2315.method_10009(item, (class_2357)behavior);
        return this.register(path, item, tags);
    }

    public class_8052 registerSmithingTemplateItem(String path, List<class_2960> baseSlotEmptyIcons, List<class_2960> additionalSlotEmptyIcons) {
        class_8052 item = SmithingTemplates.create(this.C, path).setBaseSlotEmptyIcons(baseSlotEmptyIcons).setAdditionalSlotEmptyIcons(additionalSlotEmptyIcons).build();
        return this.registerSmithingTemplateItem(path + "_smithing_template", item);
    }

    public <T extends class_8052> T registerSmithingTemplateItem(String path, T item) {
        this.register(path, item, (class_6862<class_1792>[])new class_6862[0]);
        return item;
    }

    public class_1792.class_1793 createDefaultItemSettings() {
        return new class_1792.class_1793();
    }

    public void bootstrapItemTags(ItemTagBootstrapContext ctx) {
        if (this.datagenTags != null) {
            this.datagenTags.forEach((arg_0, arg_1) -> ((ItemTagBootstrapContext)ctx).add(arg_0, arg_1));
        }
        this.items.entrySet().stream().filter(i -> i.getValue() instanceof ItemTagProvider).forEach(i -> ((ItemTagProvider)i.getValue()).registerItemTags((class_2960)i.getKey(), ctx));
    }
}

