/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.impl.modification;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_5483;
import net.minecraft.class_6012;

public class MobSettingsWorker {
    private final class_5483 mobSettings;
    private final class_1959 biome;
    private Map<class_1311, class_6012<class_5483.class_1964>> customSpawners;

    public MobSettingsWorker(class_1959 biome) {
        this.biome = biome;
        this.mobSettings = biome.method_30966();
    }

    private void unfreezeSpawners() {
        if (this.customSpawners == null) {
            this.mobSettings.field_26405 = this.customSpawners = new HashMap<class_1311, class_6012<class_5483.class_1964>>(this.mobSettings.field_26405);
        }
    }

    private void freezeSpawners() {
        if (this.customSpawners != null) {
            this.mobSettings.field_26405 = ImmutableMap.copyOf(this.customSpawners);
            this.customSpawners = null;
        }
    }

    public boolean finished() {
        boolean res = this.customSpawners != null;
        this.freezeSpawners();
        return res;
    }

    public <M extends class_1308> void addSpawns(List<class_5483.class_1964> spawns) {
        Map<class_1311, List<class_5483.class_1964>> input = spawns.stream().collect(Collectors.groupingBy(s -> s.field_9389.method_5891()));
        if (input.isEmpty()) {
            return;
        }
        this.unfreezeSpawners();
        for (class_1311 category : input.keySet()) {
            List<class_5483.class_1964> mutableSpawns;
            class_6012<class_5483.class_1964> currentSpawns = this.customSpawners.get(category);
            if (currentSpawns == null) {
                mutableSpawns = input.get(category);
            } else {
                List tmpA = currentSpawns.method_34994();
                List<class_5483.class_1964> tmpB = input.get(category);
                mutableSpawns = new ArrayList<class_5483.class_1964>(tmpA.size() + tmpB.size());
                mutableSpawns.addAll(tmpA);
                mutableSpawns.addAll(tmpB);
            }
            this.customSpawners.put(category, (class_6012<class_5483.class_1964>)class_6012.method_34988(mutableSpawns));
        }
    }
}

