/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.impl.modification;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_5455;
import net.minecraft.class_5485;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import org.betterx.wover.biome.impl.modification.FeatureMap;
import org.jetbrains.annotations.NotNull;

public class GenerationSettingsWorker {
    private final class_2378<class_2922<?>> carvers;
    private final class_2378<class_6796> features;
    private final class_5485 generationSettings;
    private final class_1959 biome;
    Map<class_2893.class_2894, class_6885<class_2922<?>>> customizedCarvers;
    List<class_6885<class_6796>> customizedFeatures;

    public GenerationSettingsWorker(class_5455 registries, class_1959 biome) {
        this.biome = biome;
        this.generationSettings = biome.method_30970();
        this.carvers = registries.method_30530(class_7924.field_41238);
        this.features = registries.method_30530(class_7924.field_41245);
    }

    private void unfreezeCarvers() {
        if (this.customizedCarvers == null) {
            this.generationSettings.field_26415 = this.customizedCarvers = new EnumMap(class_2893.class_2894.class);
        }
    }

    private void freezeCarvers() {
        if (this.customizedCarvers != null) {
            this.generationSettings.field_26415 = ImmutableMap.copyOf(this.customizedCarvers);
            this.customizedCarvers = null;
        }
    }

    private void unfreezeFeatures() {
        if (this.customizedFeatures == null) {
            this.generationSettings.field_26416 = this.customizedFeatures = new LinkedList<class_6885<class_6796>>(this.generationSettings.field_26416);
        }
    }

    private void freezeFeatures() {
        if (this.customizedFeatures != null) {
            this.generationSettings.field_26416 = ImmutableList.copyOf(this.customizedFeatures);
            this.generationSettings.field_34465 = Suppliers.memoize(this::createPlacedFeatrueSet);
            this.generationSettings.field_26640 = Suppliers.memoize(this::createFlowerFeatures);
            this.customizedFeatures = null;
        }
    }

    public boolean finished() {
        boolean res = this.customizedCarvers != null || this.customizedFeatures != null;
        this.freezeCarvers();
        this.freezeFeatures();
        return res;
    }

    private Set<class_6796> createPlacedFeatrueSet() {
        return this.getFlatFeatureStream().collect(Collectors.toSet());
    }

    private List<class_2975<?, ?>> createFlowerFeatures() {
        return (List)this.getFlatFeatureStream().flatMap(class_6796::method_39643).filter(configured -> configured.comp_332() == class_3031.field_21219).collect(ImmutableList.toImmutableList());
    }

    @NotNull
    private Stream<class_6796> getFlatFeatureStream() {
        return this.generationSettings.field_26416.stream().flatMap(class_6885::method_40239).map(class_6880::comp_349);
    }

    public void addFeatures(FeatureMap features) {
        int index;
        boolean hasNewFeatures = false;
        for (index = 0; index < features.size(); ++index) {
            if (index >= class_2893.class_2895.values().length || ((LinkedList)features.get(index)).isEmpty()) continue;
            hasNewFeatures = true;
            break;
        }
        if (!hasNewFeatures) {
            return;
        }
        this.unfreezeFeatures();
        for (index = 0; index < features.size(); ++index) {
            LinkedList newFeatures;
            if (index >= class_2893.class_2895.values().length || (newFeatures = (LinkedList)features.get(index)).isEmpty()) continue;
            class_2893.class_2895 step = class_2893.class_2895.values()[index];
            ArrayList featuresInStep = new ArrayList(FeatureMap.getFeatures(this.customizedFeatures, step).method_40239().toList());
            featuresInStep.addAll(newFeatures);
            this.customizedFeatures.set(index, (class_6885<class_6796>)class_6885.method_40242(featuresInStep));
        }
    }
}

