/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.impl.modification;

import com.google.common.base.Stopwatch;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_32;
import net.minecraft.class_3283;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6904;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import org.betterx.wover.biome.api.modification.BiomeModification;
import org.betterx.wover.biome.api.modification.BiomeModificationRegistry;
import org.betterx.wover.biome.api.modification.predicates.BiomePredicate;
import org.betterx.wover.biome.impl.modification.BiomeTagModificationWorker;
import org.betterx.wover.biome.impl.modification.GenerationSettingsWorker;
import org.betterx.wover.biome.impl.modification.MobSettingsWorker;
import org.betterx.wover.common.generator.api.biomesource.ReloadableBiomeSource;
import org.betterx.wover.common.generator.api.chunkgenerator.RebuildableFeaturesPerStep;
import org.betterx.wover.core.api.registry.DatapackRegistryBuilder;
import org.betterx.wover.entrypoint.LibWoverBiome;
import org.betterx.wover.events.api.Subscriber;
import org.betterx.wover.events.api.WorldLifecycle;
import org.betterx.wover.events.api.types.OnBootstrapRegistry;
import org.betterx.wover.events.api.types.OnMinecraftServerReady;
import org.betterx.wover.events.impl.EventImpl;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.ApiStatus;

public class BiomeModificationRegistryImpl {
    public static final EventImpl<OnBootstrapRegistry<BiomeModification>> BOOTSTRAP_BIOME_MODIFICATION_REGISTRY = new EventImpl("BOOTSTRAP_BIOME_MODIFICATION_REGISTRY");
    private static boolean didInit = false;

    @ApiStatus.Internal
    public static void initialize() {
        if (didInit) {
            return;
        }
        didInit = true;
        DatapackRegistryBuilder.register(BiomeModificationRegistry.BIOME_MODIFICATION_REGISTRY, BiomeModification.CODEC, BiomeModificationRegistryImpl::onBootstrap);
        WorldLifecycle.MINECRAFT_SERVER_READY.subscribe((Subscriber)((OnMinecraftServerReady)BiomeModificationRegistryImpl::whenReady), 100000000);
    }

    private static void onBootstrap(class_7891<BiomeModification> ctx) {
        BOOTSTRAP_BIOME_MODIFICATION_REGISTRY.emit(c -> c.bootstrap(ctx));
    }

    private static void whenReady(class_32.class_5143 storageSource, class_3283 packRepository, class_6904 worldStem) {
        class_2378 dimensions;
        Stopwatch sw = Stopwatch.createStarted();
        class_5455 registryAccess = WorldState.registryAccess();
        class_2378 modifications = registryAccess.method_33310(BiomeModificationRegistry.BIOME_MODIFICATION_REGISTRY).orElse(null);
        if (modifications == null) {
            LibWoverBiome.C.log.error("Biome Modification Registry is missing. Cannot apply Biome Modifications.");
            return;
        }
        class_2378 biomes = registryAccess.method_30530(class_7924.field_41236);
        List<class_5321> keys = biomes.method_29722().stream().map(Map.Entry::getKey).sorted(Comparator.comparingInt(key -> biomes.method_10206((Object)((class_1959)biomes.method_31140(key))))).toList();
        BiomeTagModificationWorker biomeTagWorker = new BiomeTagModificationWorker();
        List biomeModifications = modifications.method_10220().toList();
        int biomesChanged = 0;
        int biomesProcessed = 0;
        int modifiersApplied = 0;
        int tagsAdded = 0;
        for (class_5321 biomeKey : keys) {
            BiomePredicate.Context context = BiomePredicate.Context.of(registryAccess, (class_5321<class_1959>)biomeKey);
            if (context == null) {
                LibWoverBiome.C.log.warn("Failed to get biome context for {}", new Object[]{biomeKey.method_29177()});
                continue;
            }
            ++biomesProcessed;
            GenerationSettingsWorker worker = null;
            MobSettingsWorker mobWorker = null;
            boolean didChangeBiome = false;
            for (BiomeModification modification : biomeModifications) {
                if (!modification.predicate().test(context)) continue;
                if (worker == null) {
                    worker = new GenerationSettingsWorker(registryAccess, context.biome);
                }
                if (mobWorker == null) {
                    mobWorker = new MobSettingsWorker(context.biome);
                }
                if (modification.biomeTags() != null) {
                    for (class_6862<class_1959> tag : modification.biomeTags()) {
                        if (!biomeTagWorker.addBiomeToTag(tag, context)) continue;
                        ++tagsAdded;
                        didChangeBiome = true;
                    }
                }
                modification.apply(worker, mobWorker);
                ++modifiersApplied;
            }
            if (worker != null && worker.finished()) {
                didChangeBiome = true;
            }
            if (mobWorker != null && mobWorker.finished()) {
                didChangeBiome = true;
            }
            if (!didChangeBiome) continue;
            ++biomesChanged;
        }
        biomeTagWorker.finished();
        if (tagsAdded > 0) {
            dimensions = registryAccess.method_30530(class_7924.field_41224);
            dimensions.forEach(stem -> {
                class_1966 patt0$temp = stem.comp_1013().method_12098();
                if (patt0$temp instanceof ReloadableBiomeSource) {
                    ReloadableBiomeSource reloadable = (ReloadableBiomeSource)patt0$temp;
                    reloadable.reloadBiomes();
                }
            });
        }
        if (biomesProcessed > 0) {
            dimensions = registryAccess.method_30530(class_7924.field_41224);
            dimensions.forEach(stem -> {
                class_2794 patt0$temp = stem.comp_1013();
                if (patt0$temp instanceof RebuildableFeaturesPerStep) {
                    RebuildableFeaturesPerStep generator = (RebuildableFeaturesPerStep)patt0$temp;
                    generator.wover_rebuildFeaturesPerStep();
                }
            });
            LibWoverBiome.C.log.info("Applied {} biome modifications and added {} tags to {} of {} biomes in {}", new Object[]{modifiersApplied, tagsAdded, biomesChanged, biomesProcessed, sw.stop()});
        }
    }

    public static class_5321<BiomeModification> createKey(class_2960 modificationID) {
        return class_5321.method_29179(BiomeModificationRegistry.BIOME_MODIFICATION_REGISTRY, (class_2960)modificationID);
    }
}

