/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.impl.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7891;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.api.data.BiomeDataRegistry;
import org.betterx.wover.biome.impl.data.BiomeCodecRegistryImpl;
import org.betterx.wover.common.registry.api.CustomRegistryData;
import org.betterx.wover.core.api.registry.DatapackRegistryBuilder;
import org.betterx.wover.entrypoint.LibWoverBiome;
import org.betterx.wover.events.api.types.OnBootstrapRegistry;
import org.betterx.wover.events.impl.EventImpl;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class BiomeDataRegistryImpl {
    public static final EventImpl<OnBootstrapRegistry<BiomeData>> BOOTSTRAP_BIOME_DATA_REGISTRY = new EventImpl("BOOTSTRAP_BIOME_DATA_REGISTRY");
    private static final CustomRegistryData.DataKey<Map<class_5321<BiomeData>, BiomeData>> TEMP_BIOME_DATA = CustomRegistryData.createKey((class_2960)LibWoverBiome.C.id("temp_biome_data"));
    private static boolean didInit = false;

    private static void onBootstrap(class_7891<BiomeData> ctx) {
        BOOTSTRAP_BIOME_DATA_REGISTRY.emit(c -> c.bootstrap(ctx));
    }

    public static BiomeData getFromRegistryOrTemp(class_5321<class_1959> key) {
        return BiomeDataRegistryImpl.getFromRegistryOrTemp(key, BiomeData::tempOf);
    }

    @Nullable
    public static BiomeData getFromRegistryOrTemp(class_5321<class_1959> key, Function<class_5321<class_1959>, BiomeData> factory) {
        if (WorldState.allStageRegistryAccess() == null) {
            return null;
        }
        class_2378 registry = WorldState.allStageRegistryAccess().method_30530(BiomeDataRegistry.BIOME_DATA_REGISTRY);
        return BiomeDataRegistryImpl.getFromRegistryOrTemp((class_2378<BiomeData>)registry, key, factory);
    }

    public static BiomeData getFromRegistryOrTemp(class_2378<BiomeData> registry, class_5321<class_1959> key) {
        return BiomeDataRegistryImpl.getFromRegistryOrTemp(registry, key, BiomeData::tempOf);
    }

    @Nullable
    public static BiomeData getFromRegistryOrTemp(class_2378<BiomeData> registry, class_5321<class_1959> key, Function<class_5321<class_1959>, BiomeData> defaultFactory) {
        Optional oData;
        class_5321<BiomeData> dataKey = BiomeDataRegistryImpl.createKey(key.method_29177());
        if (registry != null && (oData = registry.method_31189(dataKey)).isPresent()) {
            return (BiomeData)oData.get();
        }
        if (registry instanceof CustomRegistryData) {
            CustomRegistryData tempRegistryData = (CustomRegistryData)registry;
            Map customData = (Map)tempRegistryData.wover_computeDataIfAbsent(TEMP_BIOME_DATA, k -> new HashMap());
            return customData.computeIfAbsent(dataKey, k -> BiomeData.tempOf(key));
        }
        return defaultFactory.apply(key);
    }

    @ApiStatus.Internal
    public static void initialize() {
        if (didInit) {
            return;
        }
        didInit = true;
        DatapackRegistryBuilder.register(BiomeDataRegistry.BIOME_DATA_REGISTRY, BiomeCodecRegistryImpl.CODEC, BiomeDataRegistryImpl::onBootstrap);
    }

    public static class_5321<BiomeData> createKey(class_2960 ruleID) {
        return class_5321.method_29179(BiomeDataRegistry.BIOME_DATA_REGISTRY, (class_2960)ruleID);
    }
}

