/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.api.modification.predicates;

import com.mojang.serialization.Codec;
import de.ambertation.wunderlib.configs.AbstractConfig;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1299;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2975;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7243;
import net.minecraft.class_7924;
import org.betterx.wover.biome.impl.modification.predicates.Always;
import org.betterx.wover.biome.impl.modification.predicates.And;
import org.betterx.wover.biome.impl.modification.predicates.BiomePredicateRegistryImpl;
import org.betterx.wover.biome.impl.modification.predicates.ConfigIs;
import org.betterx.wover.biome.impl.modification.predicates.HasConfiguredFeature;
import org.betterx.wover.biome.impl.modification.predicates.HasPlacedFeature;
import org.betterx.wover.biome.impl.modification.predicates.HasStructure;
import org.betterx.wover.biome.impl.modification.predicates.HasTag;
import org.betterx.wover.biome.impl.modification.predicates.InDimension;
import org.betterx.wover.biome.impl.modification.predicates.IsBiome;
import org.betterx.wover.biome.impl.modification.predicates.IsNamespace;
import org.betterx.wover.biome.impl.modification.predicates.LocationPathContains;
import org.betterx.wover.biome.impl.modification.predicates.Not;
import org.betterx.wover.biome.impl.modification.predicates.Or;
import org.betterx.wover.biome.impl.modification.predicates.Spawns;
import org.betterx.wover.core.api.ModCore;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BiomePredicate {
    public static final Codec<BiomePredicate> CODEC = BiomePredicateRegistryImpl.BIOME_PREDICATES.method_39673().dispatch(p -> p.codec().comp_640(), Function.identity());

    public static BiomePredicate or(BiomePredicate ... predicates) {
        return new Or(List.of(predicates));
    }

    public static BiomePredicate and(BiomePredicate ... predicates) {
        return new And(List.of(predicates));
    }

    public static BiomePredicate anyOf(BiomePredicate ... predicates) {
        return BiomePredicate.or(predicates);
    }

    public static BiomePredicate allOf(BiomePredicate ... predicates) {
        return BiomePredicate.and(predicates);
    }

    public static BiomePredicate not(BiomePredicate predicate) {
        return new Not(predicate);
    }

    public static BiomePredicate always() {
        return Always.INSTANCE;
    }

    public static BiomePredicate isBiome(class_5321<class_1959> key) {
        return new IsBiome(key);
    }

    @SafeVarargs
    public static BiomePredicate inBiomes(class_5321<class_1959> ... keys) {
        return new Or(Arrays.stream(keys).map(biomeKey -> new IsBiome((class_5321<class_1959>)biomeKey)).toList());
    }

    @SafeVarargs
    public static BiomePredicate notInBiomes(class_5321<class_1959> ... keys) {
        return new Not(BiomePredicate.inBiomes(keys));
    }

    public static BiomePredicate inDimension(class_5321<class_5363> key) {
        return new InDimension(key);
    }

    public static BiomePredicate inOverworld() {
        return InDimension.OVERWORLD;
    }

    public static BiomePredicate inEnd() {
        return InDimension.END;
    }

    public static BiomePredicate inNether() {
        return InDimension.NETHER;
    }

    public static BiomePredicate hasTag(class_6862<class_1959> tag) {
        return new HasTag(tag);
    }

    public static BiomePredicate spawns(class_1299<?> type) {
        return new Spawns(type);
    }

    public static BiomePredicate hasStructure(class_5321<class_3195> key) {
        return new HasStructure(key);
    }

    public static BiomePredicate hasPlacedFeature(class_5321<class_6796> key) {
        return new HasPlacedFeature(key);
    }

    public static BiomePredicate hasConfiguredFeature(class_5321<class_2975<?, ?>> key) {
        return new HasConfiguredFeature(key);
    }

    public static BiomePredicate isVanilla() {
        return new IsNamespace("minecraft");
    }

    public static BiomePredicate inNamespace(String namespace) {
        return new IsNamespace(namespace);
    }

    public static BiomePredicate inNamespace(ModCore core) {
        return new IsNamespace(core.namespace);
    }

    public static BiomePredicate notInNamespace(String namespace) {
        return BiomePredicate.not(new IsNamespace(namespace));
    }

    public static BiomePredicate notInNamespace(ModCore core) {
        return BiomePredicate.not(new IsNamespace(core.namespace));
    }

    public static BiomePredicate pathContains(String needle) {
        return new LocationPathContains(needle);
    }

    public static <T, R extends AbstractConfig.Value<T, R>> BiomePredicate hasConfig(AbstractConfig.Value<T, R> value, T targetValue) {
        return ConfigIs.of(value, targetValue);
    }

    @ApiStatus.Internal
    public class_7243<? extends BiomePredicate> codec();

    public boolean test(Context var1);

    public static final class Context {
        @NotNull
        public final class_5455 registryAccess;
        @NotNull
        public final class_5321<class_1959> biomeKey;
        @NotNull
        public final class_1959 biome;
        @NotNull
        public final class_6880<class_1959> biomeHolder;
        @NotNull
        public final class_2378<class_1959> biomes;
        @NotNull
        public final class_2378<class_5363> levelStems;
        @NotNull
        public final class_2378<class_3195> structures;
        @NotNull
        public final class_2378<class_6796> placedFeatures;
        @NotNull
        public final class_2378<class_2975<?, ?>> configuredFeatures;

        private Context(@NotNull class_5455 registryAccess, @NotNull class_2378<class_1959> biomes, @NotNull class_5321<class_1959> biomeKey, @NotNull class_1959 biome) {
            this.registryAccess = registryAccess;
            this.biomeKey = biomeKey;
            this.biomes = biomes;
            this.levelStems = registryAccess.method_30530(class_7924.field_41224);
            this.structures = registryAccess.method_30530(class_7924.field_41246);
            this.placedFeatures = registryAccess.method_30530(class_7924.field_41245);
            this.configuredFeatures = registryAccess.method_30530(class_7924.field_41239);
            this.biome = biome;
            this.biomeHolder = biomes.method_40290(biomeKey);
        }

        @ApiStatus.Internal
        @Nullable
        public static Context of(@Nullable class_5455 registryAccess, @NotNull class_5321<class_1959> biomeKey) {
            if (registryAccess == null) {
                return null;
            }
            class_2378 biomes = registryAccess.method_30530(class_7924.field_41236);
            return Context.of(registryAccess, (class_2378<class_1959>)biomes, biomeKey);
        }

        @ApiStatus.Internal
        @Nullable
        public static Context of(@Nullable class_5455 registryAccess, @Nullable class_2378<class_1959> biomes, @NotNull class_5321<class_1959> biomeKey) {
            if (biomes == null || registryAccess == null) {
                return null;
            }
            class_1959 biome = (class_1959)biomes.method_29107(biomeKey);
            if (biome == null) {
                return null;
            }
            return new Context(registryAccess, biomes, biomeKey, biome);
        }
    }
}

