/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.api.modification;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ambertation.wunderlib.configs.AbstractConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5483;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import org.betterx.wover.biome.api.modification.BiomeModificationRegistry;
import org.betterx.wover.biome.api.modification.predicates.BiomePredicate;
import org.betterx.wover.biome.impl.modification.BiomeModificationImpl;
import org.betterx.wover.biome.impl.modification.FeatureMap;
import org.betterx.wover.biome.impl.modification.GenerationSettingsWorker;
import org.betterx.wover.biome.impl.modification.MobSettingsWorker;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.feature.api.placed.BasePlacedFeatureKey;
import org.betterx.wover.structure.api.StructureKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BiomeModification {
    public static final Codec<BiomeModification> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomePredicate.CODEC.fieldOf("predicate").forGetter(BiomeModification::predicate), (App)FeatureMap.CODEC.optionalFieldOf("features", List.of()).forGetter(BiomeModification::features), (App)class_6862.method_40090((class_5321)class_7924.field_41236).listOf().optionalFieldOf("biome_tags", List.of()).forGetter(BiomeModification::biomeTags), (App)Codec.list((Codec)class_5483.class_1964.field_24681).optionalFieldOf("spawns", List.of()).forGetter(BiomeModification::spawns)).apply((Applicative)instance, BiomeModificationImpl::new));

    public BiomePredicate predicate();

    public List<List<class_6880<class_6796>>> features();

    public List<class_5483.class_1964> spawns();

    public List<class_6862<class_1959>> biomeTags();

    @ApiStatus.Internal
    public void apply(GenerationSettingsWorker var1, MobSettingsWorker var2);

    public static Builder build(@NotNull class_7891<BiomeModification> context, @NotNull class_2960 location) {
        return new Builder(context, (class_5321<BiomeModification>)class_5321.method_29179(BiomeModificationRegistry.BIOME_MODIFICATION_REGISTRY, (class_2960)location));
    }

    public static Builder build(@NotNull class_7891<BiomeModification> context, @NotNull class_5321<BiomeModification> key) {
        return new Builder(context, key);
    }

    public static final class Builder {
        @Nullable
        private final class_7891<BiomeModification> bootstrapContext;
        private BiomePredicate predicate;
        private final FeatureMap features;
        private final List<class_5483.class_1964> spawns;
        private final Set<class_6862<class_1959>> tags = new HashSet<class_6862<class_1959>>();
        private final class_5321<BiomeModification> key;

        private Builder(@Nullable class_7891<BiomeModification> bootstrapContext, class_5321<BiomeModification> key) {
            this.bootstrapContext = bootstrapContext;
            this.key = key;
            this.predicate = BiomePredicate.always();
            this.features = FeatureMap.of(new ArrayList<List<class_6880<class_6796>>>(class_2893.class_2895.values().length));
            this.spawns = new ArrayList<class_5483.class_1964>(2);
        }

        public Builder predicate(BiomePredicate p) {
            this.predicate = p;
            return this;
        }

        public Builder isBiome(class_5321<class_1959> key) {
            this.predicate(BiomePredicate.isBiome(key));
            return this;
        }

        @SafeVarargs
        public final Builder inBiomes(class_5321<class_1959> ... keys) {
            return this.predicate(BiomePredicate.inBiomes(keys));
        }

        @SafeVarargs
        public final Builder notInBiomes(class_5321<class_1959> ... keys) {
            return this.predicate(BiomePredicate.notInBiomes(keys));
        }

        public Builder inDimension(class_5321<class_5363> key) {
            return this.predicate(BiomePredicate.inDimension(key));
        }

        public Builder inOverworld() {
            return this.predicate(BiomePredicate.inOverworld());
        }

        public Builder inEnd() {
            return this.predicate(BiomePredicate.inEnd());
        }

        public Builder inNether() {
            return this.predicate(BiomePredicate.inNether());
        }

        public Builder hasTag(class_6862<class_1959> tag) {
            return this.predicate(BiomePredicate.hasTag(tag));
        }

        public Builder spawns(class_1299<?> type) {
            return this.predicate(BiomePredicate.spawns(type));
        }

        public Builder hasStructure(class_5321<class_3195> key) {
            return this.predicate(BiomePredicate.hasStructure(key));
        }

        public Builder hasPlacedFeature(class_5321<class_6796> key) {
            return this.predicate(BiomePredicate.hasPlacedFeature(key));
        }

        public Builder hasConfiguredFeature(class_5321<class_2975<?, ?>> key) {
            return this.predicate(BiomePredicate.hasConfiguredFeature(key));
        }

        public Builder anyOf(BiomePredicate ... predicates) {
            return this.predicate(BiomePredicate.or(predicates));
        }

        public Builder allOf(BiomePredicate ... predicates) {
            return this.predicate(BiomePredicate.and(predicates));
        }

        public Builder not(BiomePredicate predicate) {
            return this.predicate(BiomePredicate.not(predicate));
        }

        public Builder isVanilla() {
            return this.predicate(BiomePredicate.isVanilla());
        }

        public Builder inNamespace(String namespace) {
            return this.predicate(BiomePredicate.inNamespace(namespace));
        }

        public Builder inNamespace(ModCore core) {
            return this.predicate(BiomePredicate.inNamespace(core));
        }

        public Builder notInNamespace(String namespace) {
            return this.predicate(BiomePredicate.notInNamespace(namespace));
        }

        public Builder notInNamespace(ModCore core) {
            return this.predicate(BiomePredicate.inNamespace(core));
        }

        public <T, R extends AbstractConfig.Value<T, R>> Builder hasConfig(AbstractConfig.Value<T, R> value, T targetValue) {
            return this.predicate(BiomePredicate.hasConfig(value, targetValue));
        }

        public Builder addFeature(class_2893.class_2895 decoration, class_5321<class_6796> featureKey) {
            if (this.bootstrapContext == null) {
                throw new IllegalStateException("You can not add a ResourceKey for a PlacedFeature to a Biome Modification if no Bootstrap Context was supplied (" + String.valueOf(this.key) + ").");
            }
            class_6880.class_6883 holder = this.bootstrapContext.method_46799(class_7924.field_41245).method_46747(featureKey);
            return this.addFeature(decoration, (class_6880<class_6796>)holder);
        }

        public Builder addFeature(class_2893.class_2895 decoration, class_6880<class_6796> holder) {
            this.features.getFeatures(decoration).add(holder);
            return this;
        }

        public Builder addFeature(BasePlacedFeatureKey<?> feature) {
            if (this.bootstrapContext == null) {
                throw new IllegalStateException("You can not add a PlacedFeatureKey to a Biome Modification if no Bootstrap Context was supplied (" + String.valueOf(this.key) + ").");
            }
            return this.addFeature(feature.getDecoration(), (class_6880<class_6796>)feature.getHolder(this.bootstrapContext));
        }

        public Builder addStructureSet(StructureKey<?, ?, ?> structure) {
            if (this.bootstrapContext == null) {
                throw new IllegalStateException("You can not add a Structure to a Biome Modification if no Bootstrap Context was supplied (" + String.valueOf(this.key) + ").");
            }
            return this.addToTag((class_6862<class_1959>)structure.biomeTag());
        }

        public Builder addStructureSet(class_6862<class_1959> structureSet) {
            if (this.bootstrapContext == null) {
                throw new IllegalStateException("You can not add a Structure to a Biome Modification if no Bootstrap Context was supplied (" + String.valueOf(this.key) + ").");
            }
            return this.addToTag(structureSet);
        }

        public <M extends class_1308> Builder addSpawn(class_1299<M> entityType, int weight, int minGroupCount, int maxGroupCount) {
            return this.addSpawn(new class_5483.class_1964(entityType, weight, minGroupCount, maxGroupCount));
        }

        public <M extends class_1308> Builder addSpawn(class_5483.class_1964 spawnerData) {
            this.spawns.add(spawnerData);
            return this;
        }

        public Builder addToTag(class_6862<class_1959> tag) {
            this.tags.add(tag);
            return this;
        }

        public class_6880<BiomeModification> directHolder() {
            return class_6880.method_40223((Object)this.build());
        }

        public class_6880<BiomeModification> register() {
            if (this.key == null) {
                throw new IllegalStateException("You need to specify a key when you register a Biome Modification.");
            }
            if (this.bootstrapContext == null) {
                throw new IllegalStateException("You need to supply a key when you register a Biome Modification (" + String.valueOf(this.key) + ").");
            }
            return this.bootstrapContext.method_46838(this.key, (Object)this.build());
        }

        @NotNull
        private BiomeModificationImpl build() {
            return new BiomeModificationImpl(this.predicate, this.features.generic(), this.tags != null ? this.tags.stream().toList() : null, this.spawns);
        }
    }
}

