/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.api.builder;

import com.google.common.collect.Lists;
import de.ambertation.wunderlib.ui.ColorHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1299;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_3414;
import net.minecraft.class_3864;
import net.minecraft.class_4761;
import net.minecraft.class_4763;
import net.minecraft.class_4967;
import net.minecraft.class_4968;
import net.minecraft.class_5195;
import net.minecraft.class_5321;
import net.minecraft.class_5478;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import net.minecraft.class_6544;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6908;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import org.betterx.wover.biome.api.BiomeKey;
import org.betterx.wover.biome.api.builder.BiomeBootstrapContext;
import org.betterx.wover.biome.api.builder.BiomeSurfaceRuleBuilder;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.impl.builder.BiomeSurfaceRuleBuilderImpl;
import org.betterx.wover.biome.mixin.BiomeGenerationSettingsAccessor;
import org.betterx.wover.feature.api.placed.BasePlacedFeatureKey;
import org.betterx.wover.feature.api.placed.PlacedFeatureManager;
import org.betterx.wover.structure.api.StructureKey;
import org.betterx.wover.surface.api.AssignedSurfaceRule;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.betterx.wover.tag.api.predefined.CommonBiomeTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BiomeBuilder<B extends BiomeBuilder<B>> {
    public final BiomeKey<B> key;
    public final BiomeBootstrapContext bootstrapContext;
    public static int DEFAULT_WATER_FOG_COLOR = 329011;
    public static int DEFAULT_WATER_COLOR;
    public static int DEFAULT_NETHER_WATER_COLOR;
    public static int DEFAULT_END_WATER_COLOR;
    public static int DEFAULT_NETHER_WATER_FOG_COLOR;
    public static int DEFAULT_END_WATER_FOG_COLOR;
    public static int DEFAULT_FOG_COLOR;
    public static int DEFAULT_END_FOG_COLOR;
    public static int DEFAULT_END_SKY_COLOR;
    public static float DEFAULT_NETHER_TEMPERATURE;
    public static float DEFAULT_END_TEMPERATURE;
    public static float DEFAULT_NETHER_WETNESS;
    public static float DEFAULT_END_WETNESS;
    protected final List<class_6544.class_4762> parameters = new ArrayList<class_6544.class_4762>(1);
    @Nullable
    protected class_6862<class_1959> intendedPlacement = null;
    protected float fogDensity;
    protected final List<class_6862<class_1959>> biomeTags = new ArrayList<class_6862<class_1959>>(2);
    @Nullable
    private BiomeSurfaceRuleBuilderImpl<B> surfaceBuilder;

    public static int calculateSkyColor(float temperature) {
        return class_5478.method_30932((float)temperature);
    }

    protected BiomeBuilder(BiomeBootstrapContext context, BiomeKey<B> key) {
        this.key = key;
        this.bootstrapContext = context;
        this.fogDensity = 1.0f;
    }

    public B addClimate(class_6544.class_4762 point) {
        this.parameters.add(point);
        return (B)this;
    }

    public B addNetherClimate(float temperature, float humidity, float offset) {
        return this.addClimate(class_6544.method_38117((float)temperature, (float)humidity, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)offset));
    }

    public B addNetherClimate(float temperature, float humidity) {
        return this.addNetherClimate(temperature, humidity, 0.0f);
    }

    public B fogDensity(float density) {
        this.fogDensity = density;
        return (B)this;
    }

    public B structure(StructureKey<?, ?, ?> structure) {
        return this.tag(structure.biomeTag());
    }

    public B structure(class_6862<class_1959> structureTag) {
        return this.tag(structureTag);
    }

    protected B biomeTypeTag(class_6862<class_1959> tag) {
        if (this.intendedPlacement == null && tag != null) {
            this.intendedPlacement = tag;
        }
        return this.tag(tag);
    }

    @SafeVarargs
    public final B tag(class_6862<class_1959> ... tags) {
        for (class_6862<class_1959> biomeTag : tags) {
            if (biomeTag == null || this.biomeTags.contains(biomeTag)) continue;
            this.biomeTags.add(biomeTag);
        }
        return (B)this;
    }

    public BiomeSurfaceRuleBuilder<B> startSurface() {
        this.surfaceBuilder = new BiomeSurfaceRuleBuilderImpl<BiomeBuilder>(this.key, this);
        return this.surfaceBuilder;
    }

    public B surface(class_2680 state) {
        return ((BiomeSurfaceRuleBuilder)this.startSurface().surface(state)).finishSurface();
    }

    public B surface(class_2248 block) {
        return ((BiomeSurfaceRuleBuilder)this.startSurface().surface(block)).finishSurface();
    }

    public B surface(class_2680 top, class_2680 under) {
        return ((BiomeSurfaceRuleBuilder)((BiomeSurfaceRuleBuilder)this.startSurface().surface(top)).subsurface(under, 3)).finishSurface();
    }

    public B surface(class_2248 top, class_2248 under) {
        return ((BiomeSurfaceRuleBuilder)((BiomeSurfaceRuleBuilder)this.startSurface().surface(top)).subsurface(under, 3)).finishSurface();
    }

    public B intendedPlacement(class_6862<class_1959> biome) {
        this.intendedPlacement = biome;
        return (B)this;
    }

    public void register() {
        this.bootstrapContext.register(this);
    }

    public abstract void registerBiome(class_7891<class_1959> var1);

    public abstract void registerBiomeData(class_7891<BiomeData> var1);

    public void registerBiomeTags(TagBootstrapContext<class_1959> context) {
        for (class_6862<class_1959> biomeTag : this.biomeTags) {
            context.add(biomeTag, new class_5321[]{this.key.key});
        }
    }

    public void registerSurfaceRule(@NotNull class_7891<AssignedSurfaceRule> context) {
        if (this.surfaceBuilder != null) {
            this.surfaceBuilder.register(context);
        }
    }

    static {
        DEFAULT_NETHER_WATER_COLOR = DEFAULT_WATER_COLOR = 4159204;
        DEFAULT_END_WATER_COLOR = DEFAULT_WATER_COLOR;
        DEFAULT_END_WATER_FOG_COLOR = DEFAULT_NETHER_WATER_FOG_COLOR = 329011;
        DEFAULT_FOG_COLOR = 12638463;
        DEFAULT_END_FOG_COLOR = 0xA080A0;
        DEFAULT_END_SKY_COLOR = 0;
        DEFAULT_NETHER_TEMPERATURE = 2.0f;
        DEFAULT_END_TEMPERATURE = 0.5f;
        DEFAULT_NETHER_WETNESS = 0.0f;
        DEFAULT_END_WETNESS = 0.5f;
    }

    public static abstract class Wrapped
    extends BiomeBuilder<Wrapped> {
        protected Wrapped(BiomeBootstrapContext context, BiomeKey<Wrapped> key) {
            super(context, key);
        }
    }

    public static abstract class Vanilla
    extends VanillaBuilder<Vanilla> {
        protected Vanilla(BiomeBootstrapContext context, BiomeKey<Vanilla> key) {
            super(context, key);
        }
    }

    public static abstract class VanillaBuilder<B extends VanillaBuilder<B>>
    extends BiomeBuilder<B> {
        private class_1959.class_5484 temperatureModifier;
        private float downfall = 0.0f;
        private float temperature = 0.5f;
        private boolean hasPrecipitation = false;
        private final class_4763.class_4764 fx = new class_4763.class_4764();
        private final class_5485.class_5495 generationSettings;
        private final class_5483.class_5496 mobSpawnSettings = new class_5483.class_5496();

        protected VanillaBuilder(BiomeBootstrapContext context, BiomeKey<B> key) {
            super(context, key);
            this.temperatureModifier = class_1959.class_5484.field_26407;
            this.generationSettings = new class_5485.class_5495(this.bootstrapContext.lookup(class_7924.field_41245), this.bootstrapContext.lookup(class_7924.field_41238));
            this.fx.method_24392(DEFAULT_FOG_COLOR);
            this.fx.method_24397(DEFAULT_WATER_FOG_COLOR);
            this.fx.method_24395(DEFAULT_WATER_COLOR);
            this.fx.method_30820(VanillaBuilder.calculateSkyColor(this.temperature));
        }

        public B hasPrecipitation(boolean bl) {
            this.hasPrecipitation = bl;
            return (B)this;
        }

        public B temperature(float f) {
            this.temperature = f;
            return (B)this;
        }

        public B downfall(float f) {
            this.downfall = f;
            return (B)this;
        }

        public B temperatureAdjustment(class_1959.class_5484 temperatureModifier) {
            this.temperatureModifier = temperatureModifier;
            return (B)this;
        }

        public B temperatureFrozen() {
            return this.temperatureAdjustment(class_1959.class_5484.field_26408);
        }

        public B temperatureRegular() {
            return this.temperatureAdjustment(class_1959.class_5484.field_26407);
        }

        public B feature(BasePlacedFeatureKey<?> feature) {
            this.generationSettings.method_46676(feature.getDecoration(), feature.getHolder(this.bootstrapContext.lookup(class_7924.field_41245)));
            return (B)this;
        }

        public B feature(class_2893.class_2895 decoration, class_5321<class_6796> feature) {
            this.generationSettings.method_46676(decoration, PlacedFeatureManager.getHolder(this.bootstrapContext.lookup(class_7924.field_41245), feature));
            return (B)this;
        }

        public B feature(class_2893.class_2895 decoration, class_6880<class_6796> feature) {
            this.generationSettings.method_46676(decoration, feature);
            return (B)this;
        }

        public B feature(Consumer<class_5485.class_5495> featureAdd) {
            featureAdd.accept(this.generationSettings);
            return (B)this;
        }

        public B defaultMushrooms() {
            return this.feature(class_3864::method_16982);
        }

        public B netherDefaultOres() {
            return this.feature(class_3864::method_24382);
        }

        public B carver(class_2893.class_2894 step, class_5321<class_2922<?>> carver) {
            this.generationSettings.method_46675(step, (class_6880)this.bootstrapContext.lookup(class_7924.field_41238).method_46747(carver));
            return (B)this;
        }

        public B carver(class_2893.class_2894 step, class_6880<class_2922<?>> carver) {
            this.generationSettings.method_46675(step, carver);
            return (B)this;
        }

        public B fogColor(int color) {
            this.fx.method_24392(color);
            return (B)this;
        }

        public B fogColor(int r, int g, int b) {
            this.fx.method_24392(ColorHelper.color((int)r, (int)g, (int)b));
            return (B)this;
        }

        public B waterColor(int r, int g, int b) {
            return this.waterColor(ColorHelper.color((int)r, (int)g, (int)b));
        }

        public B waterColor(int color) {
            this.fx.method_24395(color);
            return (B)this;
        }

        public B waterFogColor(int r, int g, int b) {
            return this.waterFogColor(ColorHelper.color((int)r, (int)g, (int)b));
        }

        public B waterFogColor(int color) {
            this.fx.method_24397(color);
            return (B)this;
        }

        public B skyColor(int r, int g, int b) {
            return this.skyColor(ColorHelper.color((int)r, (int)g, (int)b));
        }

        public B skyColor(int color) {
            this.fx.method_30820(color);
            return (B)this;
        }

        public B foliageColorOverride(int r, int g, int b) {
            return this.foliageColorOverride(ColorHelper.color((int)r, (int)g, (int)b));
        }

        public B foliageColorOverride(int color) {
            this.fx.method_30821(color);
            return (B)this;
        }

        public B grassColorOverride(int r, int g, int b) {
            return this.grassColorOverride(ColorHelper.color((int)r, (int)g, (int)b));
        }

        public B grassColorOverride(int color) {
            this.fx.method_30822(color);
            return (B)this;
        }

        public B grassColorModifier(class_4763.class_5486 grassColorModifier) {
            this.fx.method_30818(grassColorModifier);
            return (B)this;
        }

        public B waterAndFogColor(int color) {
            return ((VanillaBuilder)this.waterColor(color)).waterFogColor(color);
        }

        public B waterAndFogColor(int r, int g, int b) {
            return this.waterAndFogColor(ColorHelper.color((int)r, (int)g, (int)b));
        }

        public B plantsColor(int r, int g, int b) {
            return this.plantsColor(ColorHelper.color((int)r, (int)g, (int)b));
        }

        public B plantsColor(int color) {
            return ((VanillaBuilder)this.grassColorOverride(color)).foliageColorOverride(color);
        }

        public B particles(class_2394 particle, float probability) {
            this.particles(new class_4761(particle, probability));
            return (B)this;
        }

        public B particles(class_4761 ambientParticleSettings) {
            this.fx.method_24393(ambientParticleSettings);
            return (B)this;
        }

        public B loop(class_6880<class_3414> holder) {
            this.fx.method_24942(holder);
            return (B)this;
        }

        public B mood(class_4968 ambientMoodSettings) {
            this.fx.method_24943(ambientMoodSettings);
            return (B)this;
        }

        public B mood(class_6880<class_3414> mood) {
            return this.mood(mood, 6000, 8, 2.0f);
        }

        public B mood(class_6880<class_3414> mood, int tickDelay, int blockSearchExtent, float soundPositionOffset) {
            return this.mood(new class_4968(mood, tickDelay, blockSearchExtent, (double)soundPositionOffset));
        }

        public B additions(class_4967 ambientAdditionsSettings) {
            this.fx.method_24944(ambientAdditionsSettings);
            return (B)this;
        }

        public B additions(class_6880<class_3414> additions, float intensity) {
            return this.additions(new class_4967(additions, (double)intensity));
        }

        public B additions(class_6880<class_3414> additions) {
            return this.additions(additions, 0.0111f);
        }

        public B music(@Nullable class_5195 music) {
            this.fx.method_27346(music);
            return (B)this;
        }

        public B music(class_6880<class_3414> music) {
            return this.music(music, 600, 2400, true);
        }

        public B music(class_6880<class_3414> music, int minDelay, int maxDelay, boolean replaceCurrentMusic) {
            return this.music(new class_5195(music, minDelay, maxDelay, replaceCurrentMusic));
        }

        public final B isNetherBiome() {
            return (B)((VanillaBuilder)this.biomeTypeTag((class_6862<class_1959>)class_6908.field_36518));
        }

        public final B isEndHighlandBiome() {
            return (B)((VanillaBuilder)this.biomeTypeTag((class_6862<class_1959>)CommonBiomeTags.IS_END_HIGHLAND));
        }

        public final B isEndMidlandBiome() {
            return (B)((VanillaBuilder)this.biomeTypeTag((class_6862<class_1959>)CommonBiomeTags.IS_END_MIDLAND));
        }

        public final B isEndCenterIslandBiome() {
            return (B)((VanillaBuilder)this.biomeTypeTag((class_6862<class_1959>)CommonBiomeTags.IS_END_CENTER));
        }

        public final B isEndBarrensBiome() {
            return (B)((VanillaBuilder)this.biomeTypeTag((class_6862<class_1959>)CommonBiomeTags.IS_END_BARRENS));
        }

        public final B isEndSmallIslandBiome() {
            return (B)((VanillaBuilder)this.biomeTypeTag((class_6862<class_1959>)CommonBiomeTags.IS_SMALL_END_ISLAND));
        }

        public B spawn(class_1299<?> entityType, int weight, int minGroupCount, int maxGroupCount) {
            this.mobSpawnSettings.method_31011(entityType.method_5891(), new class_5483.class_1964(entityType, weight, minGroupCount, maxGroupCount));
            return (B)this;
        }

        public B addMobCharge(class_1299<?> entityType, double energyBudget, double charge) {
            this.mobSpawnSettings.method_31009(entityType, energyBudget, charge);
            return (B)this;
        }

        public B creatureGenerationProbability(float p) {
            this.mobSpawnSettings.method_31008(p);
            return (B)this;
        }

        @Override
        public void register() {
            this.bootstrapContext.register(this);
        }

        @Override
        public void registerBiome(class_7891<class_1959> biomeContext) {
            biomeContext.method_46838(this.key.key, (Object)this.buildBiome());
        }

        @Override
        public abstract void registerBiomeData(class_7891<BiomeData> var1);

        private static class_5485 fixGenerationSettings(class_5485 settings) {
            if (settings instanceof BiomeGenerationSettingsAccessor) {
                BiomeGenerationSettingsAccessor acc = (BiomeGenerationSettingsAccessor)settings;
                HashMap carvers = new HashMap(acc.wover_getCarvers());
                for (class_2893.class_2894 step : class_2893.class_2894.values()) {
                    carvers.computeIfAbsent(step, __ -> class_6885.method_40242((List)Lists.newArrayList()));
                }
                acc.wover_setCarvers(Map.copyOf(carvers));
            }
            return settings;
        }

        protected class_1959 buildBiome() {
            class_1959.class_1960 vanillaBuilder = new class_1959.class_1960();
            vanillaBuilder.method_48164(this.hasPrecipitation);
            vanillaBuilder.method_8727(this.downfall);
            vanillaBuilder.method_8747(this.temperature);
            vanillaBuilder.method_30777(this.temperatureModifier);
            vanillaBuilder.method_30973(VanillaBuilder.fixGenerationSettings(this.generationSettings.method_46671()));
            vanillaBuilder.method_24379(this.fx.method_24391());
            vanillaBuilder.method_30974(this.mobSpawnSettings.method_31007());
            return vanillaBuilder.method_30972();
        }
    }
}

