/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.api;

import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2841;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7522;
import net.minecraft.class_7924;
import org.betterx.wover.biome.api.BiomeKey;
import org.betterx.wover.biome.api.builder.BiomeBuilder;
import org.betterx.wover.biome.api.builder.event.OnBootstrapBiomes;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.api.data.BiomeDataRegistry;
import org.betterx.wover.biome.impl.BiomeManagerImpl;
import org.betterx.wover.entrypoint.LibWoverBiome;
import org.betterx.wover.events.api.Event;
import org.betterx.wover.events.api.types.OnBootstrapRegistry;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiomeManager {
    public static final Event<OnBootstrapRegistry<class_1959>> BOOTSTRAP_BIOME_REGISTRY = BiomeManagerImpl.BOOTSTRAP_BIOME_REGISTRY;
    public static final Event<OnBootstrapBiomes> BOOTSTRAP_BIOMES_WITH_DATA = BiomeManagerImpl.BOOTSTRAP_BIOMES_WITH_DATA;

    public static BiomeKey<BiomeBuilder.Vanilla> vanilla(class_2960 location) {
        return BiomeManagerImpl.vanilla(location);
    }

    public static BiomeKey<BiomeBuilder.Wrapped> wrapped(@NotNull class_5321<class_1959> key) {
        return BiomeManagerImpl.wrapped(key);
    }

    @Nullable
    public static BiomeData biomeData(class_2960 biome) {
        return BiomeManager.biomeData((class_7225.class_7874)WorldState.registryAccess(), biome);
    }

    public static BiomeData biomeData(class_7225.class_7874 registryAccess, class_2960 biome) {
        if (registryAccess == null) {
            return null;
        }
        return registryAccess.method_46759(class_7924.field_41236).flatMap(r -> r.method_46746(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)biome))).map(h -> BiomeManager.biomeDataForHolder(registryAccess, (class_6880<class_1959>)h)).orElse(null);
    }

    @Nullable
    public static BiomeData biomeDataForHolder(class_6880<class_1959> biome) {
        return BiomeManager.biomeDataForHolder((class_7225.class_7874)WorldState.registryAccess(), biome);
    }

    @Nullable
    public static BiomeData biomeDataForHolder(class_7225.class_7874 acc, class_6880<class_1959> biome) {
        if (acc != null) {
            class_7225.class_7226 reg = acc.method_46762(BiomeDataRegistry.BIOME_DATA_REGISTRY);
            class_2960 id = biome.method_40230().map(class_5321::method_29177).orElse(null);
            if (id != null) {
                return reg.method_46746(BiomeDataRegistry.createKey(id)).map(class_6880.class_6883::comp_349).orElse(null);
            }
        }
        return null;
    }

    public static void setBiome(class_2791 chunk, class_2338 pos, class_6880<class_1959> biome) {
        int sectionY = pos.method_10264() - chunk.method_31607() >> 4;
        class_7522 biomes = chunk.method_38259(sectionY).method_38294();
        if (biomes instanceof class_2841) {
            class_2841 palette = (class_2841)biomes;
            palette.method_35321((pos.method_10263() & 0xF) >> 2, (pos.method_10264() & 0xF) >> 2, (pos.method_10260() & 0xF) >> 2, biome);
        } else {
            LibWoverBiome.C.LOG.warn("Unable to change Biome at " + String.valueOf(pos));
        }
    }

    public static void setBiome(class_1936 level, class_2338 pos, class_6880<class_1959> biome) {
        class_2791 chunk = level.method_22350(pos);
        BiomeManager.setBiome(chunk, pos, biome);
    }
}

